/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.document.impl.DocumentDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.FlowElementContainerBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;

public class DocumentDefinitionBuilder
extends FlowElementContainerBuilder {
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private final DocumentDefinitionImpl documentDefinitionImpl;

    public DocumentDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl container, String name, String fileName) {
        this(processDefinitionBuilder, container, fileName);
        this.documentDefinitionImpl.setFileName(fileName);
    }

    public DocumentDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl container, String name) {
        super(container, processDefinitionBuilder);
        this.documentDefinitionImpl = new DocumentDefinitionImpl(name);
        this.documentDefinitionImpl.setMimeType(DEFAULT_MIME_TYPE);
        container.addDocumentDefinition(this.documentDefinitionImpl);
    }

    public DocumentDefinitionBuilder addDescription(String description) {
        this.documentDefinitionImpl.setDescription(description);
        return this;
    }

    public DocumentDefinitionBuilder addUrl(String url) {
        if (this.documentDefinitionImpl.getFile() == null) {
            this.documentDefinitionImpl.setUrl(url);
        } else {
            this.getProcessBuilder().addError("Unable to add an url on a document that already have a file " + this.documentDefinitionImpl);
        }
        return this;
    }

    public DocumentDefinitionBuilder addContentFileName(String contentFilename) {
        if (this.documentDefinitionImpl.getFileName() == null) {
            this.documentDefinitionImpl.setFileName(contentFilename);
        } else {
            this.getProcessBuilder().addError("Unable to add file name on a document that already have a file name " + this.documentDefinitionImpl);
        }
        return this;
    }

    public DocumentDefinitionBuilder addFile(String file) {
        if (this.documentDefinitionImpl.getUrl() == null) {
            this.documentDefinitionImpl.setFile(file);
        } else {
            this.getProcessBuilder().addError("Unable to add a file on a document that already have an url");
        }
        return this;
    }

    public DocumentDefinitionBuilder addMimeType(String mimeType) {
        this.documentDefinitionImpl.setMimeType(mimeType);
        return this;
    }
}

