/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.flownode.impl.internal.ActivityDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.MultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;

public class MultiInstanceLoopCharacteristicsBuilder {
    private final MultiInstanceLoopCharacteristics entity;
    private final ProcessDefinitionBuilder builder;
    private final ActivityDefinitionImpl activityDefinition;

    public MultiInstanceLoopCharacteristicsBuilder(ProcessDefinitionBuilder builder, ActivityDefinitionImpl activityDefinition, boolean isSequential, Expression loopCardinality) {
        this.activityDefinition = activityDefinition;
        this.builder = builder;
        this.entity = new MultiInstanceLoopCharacteristics(isSequential, loopCardinality);
        activityDefinition.setLoopCharacteristics(this.entity);
        if (!Integer.class.getName().equals(loopCardinality.getReturnType())) {
            builder.addError("the loop cardinality of the looped activity " + activityDefinition.getName() + " do not have the return type \"Integer\"");
        }
    }

    public MultiInstanceLoopCharacteristicsBuilder(ProcessDefinitionBuilder builder, ActivityDefinitionImpl activityDefinition, boolean isSequential, String loopDataInputRef) {
        this.activityDefinition = activityDefinition;
        this.builder = builder;
        this.entity = new MultiInstanceLoopCharacteristics(isSequential, loopDataInputRef);
        activityDefinition.setLoopCharacteristics(this.entity);
    }

    public MultiInstanceLoopCharacteristicsBuilder addCompletionCondition(Expression completionCondition) {
        this.entity.setCompletionCondition(completionCondition);
        if (!Boolean.class.getName().equals(completionCondition.getReturnType())) {
            this.builder.addError("the completion condition of the looped activity " + this.activityDefinition.getName() + " do not have the return type \"Boolean\"");
        }
        return this;
    }

    public MultiInstanceLoopCharacteristicsBuilder addLoopDataOutputRef(String loopDataOutputRef) {
        this.entity.setLoopDataOutputRef(loopDataOutputRef);
        return this;
    }

    public MultiInstanceLoopCharacteristicsBuilder addDataInputItemRef(String dataItemRef) {
        this.entity.setDataInputItemRef(dataItemRef);
        return this;
    }

    public MultiInstanceLoopCharacteristicsBuilder addDataOutputItemRef(String dataItemRef) {
        this.entity.setDataOutputItemRef(dataItemRef);
        return this;
    }
}

