/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.userfilter.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bonitasoft.engine.bpm.internal.NamedElementImpl;
import org.bonitasoft.engine.bpm.userfilter.UserFilterDefinition;
import org.bonitasoft.engine.expression.Expression;

public class UserFilterDefinitionImpl
extends NamedElementImpl
implements UserFilterDefinition {
    private static final long serialVersionUID = -6045216424839658552L;
    private final String filterId;
    private final String version;
    private final Map<String, Expression> inputs = new HashMap<String, Expression>();

    public UserFilterDefinitionImpl(String name, String filterId, String version) {
        super(name);
        this.filterId = filterId;
        this.version = version;
    }

    @Override
    public String getUserFilterId() {
        return this.filterId;
    }

    @Override
    public Map<String, Expression> getInputs() {
        return this.inputs;
    }

    public void addInput(String name, Expression expression) {
        this.inputs.put(name, expression);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.filterId == null ? 0 : this.filterId.hashCode());
        result = 31 * result + (this.inputs == null ? 0 : this.inputs.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserFilterDefinitionImpl other = (UserFilterDefinitionImpl)obj;
        if (this.filterId == null ? other.filterId != null : !this.filterId.equals(other.filterId)) {
            return false;
        }
        if (this.inputs == null ? other.inputs != null : !this.inputs.equals(other.inputs)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    public String toString() {
        int maxLen = 5;
        StringBuilder builder = new StringBuilder();
        builder.append("UserFilterDefinitionImpl [filterId=");
        builder.append(this.filterId);
        builder.append(", version=");
        builder.append(this.version);
        builder.append(", inputs=");
        builder.append(this.inputs != null ? this.toString(this.inputs.entrySet(), 5) : null);
        builder.append("]");
        return builder.toString();
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }
}

