/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bonitasoft.engine.exception.BonitaRuntimeException;

public class IOUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TMP_DIRECTORY = System.getProperty("java.io.tmpdir");
    private static final int BUFFER_SIZE = 100000;
    public static final String FILE_ENCODING = "UTF-8";
    private static final String JVM_NAME = ManagementFactory.getRuntimeMXBean().getName();

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return IOUtil.generateJar(IOUtil.getResources(classes));
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            String message = "No classes available";
            throw new IOException("No classes available");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName().replace(".", "/") + ".class", IOUtil.getClassData(clazz));
            for (Class<?> internalClass : clazz.getDeclaredClasses()) {
                resources.put(internalClass.getName().replace(".", "/") + ".class", IOUtil.getClassData(internalClass));
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassData(Class<?> clazz) throws IOException {
        if (clazz == null) {
            String message = "Class is null";
            throw new IOException("Class is null");
        }
        String resource = clazz.getName().replace('.', '/') + ".class";
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(resource);
        byte[] data = null;
        try {
            if (inputStream == null) {
                throw new IOException("Impossible to get stream from class: " + clazz.getName() + ", className= " + resource);
            }
            data = IOUtil.getAllContentFrom(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.isEmpty()) {
            String message = "No resources available";
            throw new IOException("No resources available");
        }
        ByteArrayOutputStream baos = null;
        ZipOutputStream jarOutStream = null;
        try {
            baos = new ByteArrayOutputStream();
            jarOutStream = new JarOutputStream(new BufferedOutputStream(baos));
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                ((JarOutputStream)jarOutStream).putNextEntry(new JarEntry(resource.getKey()));
                jarOutStream.write(resource.getValue());
            }
            jarOutStream.flush();
            baos.flush();
        }
        finally {
            if (jarOutStream != null) {
                jarOutStream.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        byte[] resultArray;
        if (in == null) {
            throw new IOException("The InputStream is null!");
        }
        byte[] buffer = new byte[100000];
        BufferedInputStream bis = null;
        ByteArrayOutputStream result = null;
        try {
            int amountRead;
            bis = new BufferedInputStream(in);
            result = new ByteArrayOutputStream();
            while ((amountRead = bis.read(buffer)) > 0) {
                result.write(buffer, 0, amountRead);
            }
            resultArray = result.toByteArray();
            result.flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static File createTempDirectoryInDefaultTempDirectory(String directoryName) {
        File tmpDir = new File(TMP_DIRECTORY, directoryName + "_" + JVM_NAME + "_" + System.currentTimeMillis());
        IOUtil.createTempDirectory(tmpDir);
        return tmpDir;
    }

    public static File createTempDirectory(URI directoryPath) {
        File tmpDir = new File(directoryPath);
        IOUtil.createTempDirectory(tmpDir);
        return tmpDir;
    }

    private static void createTempDirectory(final File tmpDir) {
        tmpDir.setReadable(true);
        tmpDir.setWritable(true);
        IOUtil.mkdirs(tmpDir);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    boolean deleted = IOUtil.deleteDir(tmpDir);
                    if (!deleted) {
                        System.err.println("Unable to delete the directory: " + tmpDir);
                    }
                }
                catch (IOException e) {
                    throw new BonitaRuntimeException(e);
                }
            }
        });
    }

    public static boolean deleteDir(File dir) throws IOException {
        return IOUtil.deleteDir(dir, 1, 0L);
    }

    public static boolean deleteDir(File dir, int attempts, long sleepTime) throws IOException {
        if (dir != null) {
            boolean result = true;
            if (!dir.exists()) {
                return true;
            }
            if (!dir.isDirectory()) {
                throw new IOException("Unable to delete directory: " + dir + ", it is not a directory");
            }
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    result &= IOUtil.deleteDir(file, attempts, sleepTime);
                    continue;
                }
                result &= IOUtil.deleteFile(file, attempts, sleepTime);
            }
            return result && IOUtil.deleteFile(dir, attempts, sleepTime);
        }
        return false;
    }

    public static File createTempFileInDefaultTempDirectory(String prefix, String suffix) throws IOException {
        return IOUtil.createTempFile(prefix, suffix, new File(TMP_DIRECTORY));
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        final File tmpFile = IOUtil.createTempFileUntilSuccess(prefix, suffix, directory);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (tmpFile != null) {
                    IOUtil.deleteFile(tmpFile, 1, 0L);
                }
            }
        });
        return tmpFile;
    }

    private static File createTempFileUntilSuccess(String prefix, String suffix, File directory) throws IOException {
        File tmpFile = null;
        int retryNumber = 10;
        int j = 0;
        boolean succeded = false;
        do {
            try {
                int lastIndexOfSeparatorChar = prefix.lastIndexOf(47);
                String fileName = prefix;
                if (lastIndexOfSeparatorChar > -1) {
                    String dirToCreate = prefix.substring(0, lastIndexOfSeparatorChar);
                    new File(directory.getAbsolutePath() + File.separator + dirToCreate).mkdirs();
                    fileName = prefix.substring(lastIndexOfSeparatorChar, prefix.length());
                }
                tmpFile = File.createTempFile(fileName, suffix, directory);
                succeded = true;
            }
            catch (IOException e) {
                if (j == 10) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                ++j;
            }
        } while (!succeded);
        return tmpFile;
    }

    public static boolean deleteFile(File f, int attempts, long sleepTime) {
        int retries = attempts;
        while (retries > 0 && !f.delete()) {
            --retries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {}
        }
        return retries > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(Map<String, byte[]> files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                zos.putNextEntry(new ZipEntry(file.getKey()));
                zos.write(file.getValue());
                zos.closeEntry();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            zos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(String dir2zip, ZipOutputStream zos, String root) throws IOException {
        File zipDir = new File(dir2zip);
        byte[] readBuffer = new byte[100000];
        int bytesIn = 0;
        for (String pathName : zipDir.list()) {
            File file = new File(zipDir, pathName);
            String path = file.getPath();
            if (file.isDirectory()) {
                IOUtil.zipDir(path, zos, root);
                continue;
            }
            try {
                ZipEntry anEntry = new ZipEntry(path.substring(root.length() + 1, path.length()).replace(String.valueOf(File.separatorChar), "/"));
                zos.putNextEntry(anEntry);
                bytesIn = IOUtil.copyFileToZip(zos, readBuffer, file, bytesIn);
                zos.flush();
            }
            finally {
                zos.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copyFileToZip(ZipOutputStream zos, byte[] readBuffer, File file, int bytesInOfZip) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        int bytesIn = bytesInOfZip;
        try {
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
        finally {
            fis.close();
        }
        return bytesIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(inputStream, FILE_ENCODING);
            String string = IOUtil.read(scanner);
            return string;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private static String read(Scanner scanner) {
        StringBuilder text = new StringBuilder();
        boolean isFirst = true;
        while (scanner.hasNextLine()) {
            if (isFirst) {
                text.append(scanner.nextLine());
            } else {
                text.append(LINE_SEPARATOR + scanner.nextLine());
            }
            isFirst = false;
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string = IOUtil.read(fileInputStream);
            return string;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipToFolder(InputStream inputStream, File outputFolder) throws IOException {
        ZipInputStream zipInputstream = new ZipInputStream(inputStream);
        try {
            IOUtil.extractZipEntries(zipInputstream, outputFolder);
        }
        finally {
            zipInputstream.closeEntry();
            zipInputstream.close();
        }
    }

    private static boolean mkdirs(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipEntries(ZipInputStream zipInputstream, File outputFolder) throws FileNotFoundException, IOException {
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputstream.getNextEntry()) != null) {
            try {
                File outputFile = new File(outputFolder.getAbsolutePath(), zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    IOUtil.mkdirs(outputFile);
                    continue;
                }
                IOUtil.writeZipInputToFile(zipInputstream, outputFile);
            }
            finally {
                zipInputstream.closeEntry();
            }
        }
    }

    private static void writeZipInputToFile(ZipInputStream zipInputstream, File outputFile) throws FileNotFoundException, IOException {
        IOUtil.mkdirs(outputFile.getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        try {
            int bytesRead;
            byte[] buffer = new byte[100000];
            while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
            fileOutputStream.flush();
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContentToFile(String content, File outputFile) throws IOException {
        FileOutputStream fileOutput = new FileOutputStream(outputFile);
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)fileOutput, FILE_ENCODING);
            out.write(content);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
            fileOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, Map.Entry<String, byte[]> entry) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(entry.getValue());
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(File file) throws FileNotFoundException, IOException {
        AbstractInterruptibleChannel ch = null;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            ch = fin.getChannel();
            int size = (int)((FileChannel)ch).size();
            MappedByteBuffer buf = ((FileChannel)ch).map(FileChannel.MapMode.READ_ONLY, 0L, size);
            byte[] bytes = new byte[size];
            buf.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (ch != null) {
                ch.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }
}

