/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FeatureIntensity;
import boofcv.alg.feature.detect.intensity.impl.FastCornerInterface;
import boofcv.misc.DiscretizedCircle;
import boofcv.struct.ListIntPoint2D;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class FastCornerDetector<T extends ImageGray<T>>
implements FeatureIntensity<T> {
    protected static final int radius = 3;
    protected int[] offsets;
    private int stride = 0;
    private final ListIntPoint2D candidatesLow = new ListIntPoint2D();
    private final ListIntPoint2D candidatesHigh = new ListIntPoint2D();
    protected T image;
    protected FastCornerInterface<T> helper;

    public FastCornerDetector(FastCornerInterface<T> helper) {
        this.helper = helper;
    }

    @Override
    public int getRadius() {
        return 3;
    }

    @Override
    public int getIgnoreBorder() {
        return 3;
    }

    public void process(T image, GrayF32 intensity) {
        this.candidatesLow.configure(((ImageGray)image).width, ((ImageGray)image).height);
        this.candidatesHigh.configure(((ImageGray)image).width, ((ImageGray)image).height);
        this.image = image;
        if (this.stride != ((ImageGray)image).stride) {
            this.stride = ((ImageGray)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets((double)3.0, (int)((ImageGray)image).stride);
        }
        this.helper.setImage(image, this.offsets);
        for (int y = 3; y < ((ImageGray)image).height - 3; ++y) {
            int indexIntensity = intensity.startIndex + y * intensity.stride + 3;
            int index = ((ImageGray)image).startIndex + y * ((ImageGray)image).stride + 3;
            int x = 3;
            while (x < ((ImageGray)image).width - 3) {
                int result = this.helper.checkPixel(index);
                if (result < 0) {
                    intensity.data[indexIntensity] = this.helper.scoreLower(index);
                    this.candidatesLow.add(x, y);
                } else if (result > 0) {
                    intensity.data[indexIntensity] = this.helper.scoreUpper(index);
                    this.candidatesHigh.add(x, y);
                } else {
                    intensity.data[indexIntensity] = 0.0f;
                }
                ++x;
                ++index;
                ++indexIntensity;
            }
        }
    }

    public void process(T image) {
        this.candidatesLow.configure(((ImageGray)image).width, ((ImageGray)image).height);
        this.candidatesHigh.configure(((ImageGray)image).width, ((ImageGray)image).height);
        this.image = image;
        if (this.stride != ((ImageGray)image).stride) {
            this.stride = ((ImageGray)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets((double)3.0, (int)((ImageGray)image).stride);
        }
        this.helper.setImage(image, this.offsets);
        for (int y = 3; y < ((ImageGray)image).height - 3; ++y) {
            int index = ((ImageGray)image).startIndex + y * ((ImageGray)image).stride + 3;
            int x = 3;
            while (x < ((ImageGray)image).width - 3) {
                int result = this.helper.checkPixel(index);
                if (result < 0) {
                    this.candidatesLow.add(x, y);
                } else if (result > 0) {
                    this.candidatesHigh.add(x, y);
                }
                ++x;
                ++index;
            }
        }
    }

    public Class<T> getImageType() {
        return this.helper.getImageType();
    }

    public ListIntPoint2D getCandidatesLow() {
        return this.candidatesLow;
    }

    public ListIntPoint2D getCandidatesHigh() {
        return this.candidatesHigh;
    }
}

