/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;

public class ImplXCornerAbeles2019Intensity_MT {
    public static void process(GrayF32 input, GrayF32 intensity) {
        int radius = 3;
        int width = input.width;
        float[] src = input.data;
        ImageMiscOps.fillBorder((GrayF32)intensity, (float)0.0f, (int)3);
        BoofConcurrency.loopFor((int)3, (int)(input.height - 3), y -> {
            int inputIdx0 = input.startIndex + (y - 3) * input.stride + 3;
            int inputIdx1 = input.startIndex + (y - 2) * input.stride + 3;
            int inputIdx2 = input.startIndex + (y - 1) * input.stride + 3;
            int inputIdx3 = input.startIndex + y * input.stride + 3;
            int inputIdx4 = input.startIndex + (y + 1) * input.stride + 3;
            int inputIdx5 = input.startIndex + (y + 2) * input.stride + 3;
            int inputIdx6 = input.startIndex + (y + 3) * input.stride + 3;
            int outputIdx = intensity.startIndex + y * intensity.stride + 3;
            for (int x = 3; x < width - 3; ++x) {
                float v00 = src[inputIdx0];
                float v01 = src[inputIdx0 + 1];
                float v02 = src[inputIdx1 + 2];
                float v03 = src[inputIdx2 + 3];
                float v04 = src[inputIdx3 + 3];
                float v05 = src[inputIdx4 + 3];
                float v06 = src[inputIdx5 + 2];
                float v07 = src[inputIdx6 + 1];
                float v08 = src[inputIdx6];
                float v09 = src[inputIdx6 - 1];
                float v10 = src[inputIdx5 - 2];
                float v11 = src[inputIdx4 - 3];
                float v12 = src[inputIdx3 - 3];
                float v13 = src[inputIdx2 - 3];
                float v14 = src[inputIdx1 - 2];
                float v15 = src[inputIdx0 - 1];
                float a = v15 + v00 + v01;
                float b = v03 + v04 + v05;
                float c = v07 + v08 + v09;
                float d = v11 + v12 + v13;
                float e = v01 + v02 + v03;
                float f = v05 + v06 + v07;
                float g = v09 + v10 + v11;
                float h = v13 + v14 + v15;
                intensity.data[outputIdx++] = Math.max(ImplXCornerAbeles2019Intensity_MT.score(a, b, c, d), ImplXCornerAbeles2019Intensity_MT.score(e, f, g, h));
                ++inputIdx0;
                ++inputIdx1;
                ++inputIdx2;
                ++inputIdx3;
                ++inputIdx4;
                ++inputIdx5;
                ++inputIdx6;
            }
        });
    }

    private static float score(float a, float b, float c, float d) {
        float mean = (a + b + c + d) / 4.0f;
        return (a - mean) * (c - mean) + (b - mean) * (d - mean);
    }
}

