/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointScaleSpacePyramid;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.struct.QueueCorner;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;

public class FeaturePyramid<T extends ImageGray<T>, D extends ImageGray<D>>
implements InterestPointScaleSpacePyramid<T> {
    private final GeneralFeatureDetector<T, D> detector;
    private final float baseThreshold;
    protected GrayF32[] intensities;
    protected int spaceIndex = 0;
    protected List<Point2D_I16>[] maximums;
    protected List<ScalePoint> foundPoints = new ArrayList<ScalePoint>();
    protected AnyImageDerivative<T, D> computeDerivative;
    protected double scalePower;

    public FeaturePyramid(GeneralFeatureDetector<T, D> detector, AnyImageDerivative<T, D> computeDerivative, double scalePower) {
        this.detector = detector;
        this.baseThreshold = detector.getThreshold();
        this.computeDerivative = computeDerivative;
        this.scalePower = scalePower;
    }

    @Override
    public void detect(PyramidFloat<T> ss) {
        this.spaceIndex = 0;
        if (this.intensities == null) {
            this.intensities = new GrayF32[3];
            this.intensities[0] = new GrayF32(1, 1);
            this.intensities[1] = new GrayF32(1, 1);
            this.intensities[2] = new GrayF32(1, 1);
            this.maximums = new List[3];
            this.maximums[0] = new ArrayList<Point2D_I16>();
            this.maximums[1] = new ArrayList<Point2D_I16>();
            this.maximums[2] = new ArrayList<Point2D_I16>();
        }
        this.foundPoints.clear();
        for (int i = 0; i < ss.getNumLayers(); ++i) {
            this.detectCandidateFeatures((ImageGray)ss.getLayer(i), ss.getSigma(i));
            if (i < 2) continue;
            this.findLocalScaleSpaceMax(ss, i - 1);
        }
    }

    private void detectCandidateFeatures(T image, double sigma) {
        float scaleThreshold = (float)((double)this.baseThreshold / Math.pow(sigma, this.scalePower));
        this.detector.setThreshold(scaleThreshold);
        this.computeDerivative.setInput(image);
        ImageGray derivX = null;
        ImageGray derivY = null;
        ImageGray derivXX = null;
        ImageGray derivYY = null;
        ImageGray derivXY = null;
        if (this.detector.getRequiresGradient()) {
            derivX = this.computeDerivative.getDerivative(new boolean[]{true});
            derivY = this.computeDerivative.getDerivative(new boolean[]{false});
        }
        if (this.detector.getRequiresHessian()) {
            derivXX = this.computeDerivative.getDerivative(new boolean[]{true, true});
            derivYY = this.computeDerivative.getDerivative(new boolean[]{false, false});
            derivXY = this.computeDerivative.getDerivative(new boolean[]{true, false});
        }
        this.detector.process(image, derivX, derivY, derivXX, derivYY, derivXY);
        this.intensities[this.spaceIndex].reshape(((ImageGray)image).width, ((ImageGray)image).height);
        this.intensities[this.spaceIndex].setTo((ImageGray)this.detector.getIntensity());
        List<Point2D_I16> m = this.maximums[this.spaceIndex];
        m.clear();
        QueueCorner q = this.detector.getMaximums();
        for (int i = 0; i < q.size; ++i) {
            m.add(((Point2D_I16)q.get(i)).copy());
        }
        ++this.spaceIndex;
        if (this.spaceIndex >= 3) {
            this.spaceIndex = 0;
        }
    }

    protected void findLocalScaleSpaceMax(PyramidFloat<T> ss, int layerID) {
        int index0 = this.spaceIndex;
        int index1 = (this.spaceIndex + 1) % 3;
        int index2 = (this.spaceIndex + 2) % 3;
        List<Point2D_I16> candidates = this.maximums[index1];
        ImageBorder_F32 inten0 = FactoryImageBorderAlgs.value((GrayF32)this.intensities[index0], (float)0.0f);
        GrayF32 inten1 = this.intensities[index1];
        ImageBorder_F32 inten2 = FactoryImageBorderAlgs.value((GrayF32)this.intensities[index2], (float)0.0f);
        float scale0 = (float)ss.scale[layerID - 1];
        float scale1 = (float)ss.scale[layerID];
        float scale2 = (float)ss.scale[layerID + 1];
        float sigma0 = (float)ss.getSigma(layerID - 1);
        float sigma1 = (float)ss.getSigma(layerID);
        float sigma2 = (float)ss.getSigma(layerID + 1);
        float ss0 = (float)(Math.pow(sigma0, this.scalePower) / (double)scale0);
        float ss1 = (float)(Math.pow(sigma1, this.scalePower) / (double)scale1);
        float ss2 = (float)(Math.pow(sigma2, this.scalePower) / (double)scale2);
        for (int canIdx = 0; canIdx < candidates.size(); ++canIdx) {
            Point2D_I16 c = candidates.get(canIdx);
            float val = ss1 * inten1.get((int)c.x, (int)c.y);
            int x0 = (int)((float)c.x * scale1 / scale0);
            int y0 = (int)((float)c.y * scale1 / scale0);
            int x2 = (int)((float)c.x * scale1 / scale2);
            int y2 = (int)((float)c.y * scale1 / scale2);
            if (!FeaturePyramid.checkMax(inten0, val / ss0, x0, y0) || !FeaturePyramid.checkMax(inten2, val / ss2, x2, y2)) continue;
            this.foundPoints.add(new ScalePoint((float)c.x * scale1, (float)c.y * scale1, sigma1));
        }
    }

    protected static boolean checkMax(ImageBorder_F32 inten, float bestScore, int c_x, int c_y) {
        boolean isMax = true;
        block0: for (int i = c_y - 1; i <= c_y + 1; ++i) {
            for (int j = c_x - 1; j <= c_x + 1; ++j) {
                if (!(inten.get(j, i) >= bestScore)) continue;
                isMax = false;
                break block0;
            }
        }
        return isMax;
    }

    @Override
    public List<ScalePoint> getInterestPoints() {
        return this.foundPoints;
    }

    public GeneralFeatureDetector<T, D> getDetector() {
        return this.detector;
    }
}

