/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.line.HoughTransformParameters;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;

public class HoughTransformBinary {
    NonMaxSuppression extractor;
    DogArray<LineParametric2D_F32> linesAll = new DogArray(10, LineParametric2D_F32::new);
    List<LineParametric2D_F32> linesMerged = new ArrayList<LineParametric2D_F32>();
    GrayF32 transform = new GrayF32(1, 1);
    QueueCorner foundPeaks = new QueueCorner(10);
    DogArray_F32 foundIntensity = new DogArray_F32(10);
    HoughTransformParameters parameters;
    ImageLinePruneMerge post = new ImageLinePruneMerge();
    double mergeAngle = 0.15707963267948966;
    double mergeDistance = 10.0;
    int maxLines = 0;
    ConfigLength thresholdCounts = ConfigLength.relative((double)0.001, (double)1.0);

    public HoughTransformBinary(NonMaxSuppression extractor, HoughTransformParameters parameters) {
        this.extractor = extractor;
        this.parameters = parameters;
    }

    public void transform(GrayU8 binary) {
        this.parameters.initialize(binary.width, binary.height, this.transform);
        ImageMiscOps.fill((GrayF32)this.transform, (float)0.0f);
        this.computeParameters(binary);
        this.extractLines();
        if (this.maxLines <= 0) {
            this.linesMerged.clear();
            this.linesMerged.addAll(this.linesAll.toList());
        } else {
            this.mergeLines(binary.width, binary.height);
        }
    }

    void computeParameters(GrayU8 binary) {
        for (int y = 0; y < binary.height; ++y) {
            int start = binary.startIndex + y * binary.stride;
            int stop = start + binary.width;
            for (int index = start; index < stop; ++index) {
                if (binary.data[index] == 0) continue;
                this.parameters.parameterize(index - start, y, this.transform);
            }
        }
    }

    protected void extractLines() {
        this.linesAll.reset();
        this.foundPeaks.reset();
        this.foundIntensity.reset();
        this.extractor.setThresholdMaximum((float)this.thresholdCounts.compute((double)(this.transform.width * this.transform.height)));
        this.extractor.process(this.transform, null, null, null, this.foundPeaks);
        for (int i = 0; i < this.foundPeaks.size(); ++i) {
            Point2D_I16 p = (Point2D_I16)this.foundPeaks.get(i);
            if (!this.parameters.isTransformValid(p.x, p.y)) continue;
            this.parameters.transformToLine(p.x, p.y, (LineParametric2D_F32)this.linesAll.grow());
            this.foundIntensity.push(this.transform.get((int)p.x, (int)p.y));
        }
    }

    protected void mergeLines(int width, int height) {
        this.post.reset();
        for (int i = 0; i < this.linesAll.size(); ++i) {
            this.post.add((LineParametric2D_F32)this.linesAll.get(i), this.foundIntensity.get(i));
        }
        this.post.pruneSimilar((float)this.mergeAngle, (float)this.mergeDistance, width, height);
        this.post.pruneNBest(this.maxLines);
        this.post.createList(this.linesMerged);
    }

    public GrayF32 getTransform() {
        return this.transform;
    }

    public float[] getFoundIntensity() {
        return this.foundIntensity.data;
    }

    public DogArray<LineParametric2D_F32> getLinesAll() {
        return this.linesAll;
    }

    public List<LineParametric2D_F32> getLinesMerged() {
        return this.linesMerged;
    }

    public double getMergeAngle() {
        return this.mergeAngle;
    }

    public void setMergeAngle(double mergeAngle) {
        this.mergeAngle = mergeAngle;
    }

    public double getMergeDistance() {
        return this.mergeDistance;
    }

    public void setMergeDistance(double mergeDistance) {
        this.mergeDistance = mergeDistance;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public HoughTransformParameters getParameters() {
        return this.parameters;
    }

    public void setNumberOfCounts(ConfigLength counts) {
        this.thresholdCounts = counts;
    }
}

