/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.cc;

import boofcv.alg.segmentation.cc.ConnectedSpeckleFiller;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageGray;
import org.ddogleg.struct.DogArray_I32;

public abstract class ConnectedTwoRowSpeckleFiller<T extends ImageGray<T>>
implements ConnectedSpeckleFiller<T> {
    protected int totalFilled;
    DogArray_I32 labelsA = new DogArray_I32();
    DogArray_I32 labelsB = new DogArray_I32();
    DogArray_I32 pixXinA = new DogArray_I32();
    DogArray_I32 pixXinB = new DogArray_I32();
    DogArray_I32 countsA = new DogArray_I32();
    DogArray_I32 countsB = new DogArray_I32();
    final DogArray_I32 connectAtoB = new DogArray_I32();
    final DogArray_I32 merge = new DogArray_I32();
    final DogArray_I32 finished = new DogArray_I32();
    T image;

    @Override
    public void process(T image, int maximumArea, double _similarTol, double _fillValue) {
        this.initTypeSpecific(_similarTol, _fillValue);
        this.init(image);
        this.countsA.size = this.labelRow(((ImageGray)image).startIndex, this.labelsA.data, this.countsA.data, this.pixXinA.data);
        for (int y = 1; y < ((ImageGray)image).height; ++y) {
            int startRowB = ((ImageGray)image).startIndex + y * ((ImageGray)image).stride;
            int startRowA = startRowB - ((ImageGray)image).stride;
            this.countsB.size = this.labelRow(startRowB, this.labelsB.data, this.countsB.data, this.pixXinB.data);
            this.findConnectionsBetweenRows(startRowA, startRowB);
            this.mergeClustersInB();
            this.addCountsRowAIntoB();
            for (int idxClosed = 0; idxClosed < this.finished.size; ++idxClosed) {
                int labelA = this.finished.get(idxClosed);
                int count = this.countsA.get(labelA);
                BoofMiscOps.checkTrue((count > 0 ? 1 : 0) != 0, (String)"BUG! a merged cluster was added");
                if (count > maximumArea) continue;
                this.fillCluster(this.pixXinA.get(labelA), y - 1, count);
            }
            DogArray_I32 tmp = this.labelsA;
            this.labelsA = this.labelsB;
            this.labelsB = tmp;
            tmp = this.countsA;
            this.countsA = this.countsB;
            this.countsB = tmp;
            tmp = this.pixXinA;
            this.pixXinA = this.pixXinB;
            this.pixXinB = tmp;
        }
        for (int labelA = 0; labelA < this.countsA.size; ++labelA) {
            int count = this.countsA.data[labelA];
            if (count == 0 || count > maximumArea) continue;
            this.fillCluster(this.pixXinA.get(labelA), ((ImageGray)image).height - 1, count);
        }
    }

    protected abstract void initTypeSpecific(double var1, double var3);

    private void init(T image) {
        this.image = image;
        this.totalFilled = 0;
        this.labelsA.resize(((ImageGray)image).width);
        this.labelsB.resize(((ImageGray)image).width);
        this.pixXinA.resize(((ImageGray)image).width);
        this.pixXinB.resize(((ImageGray)image).width);
        this.countsA.reserve(((ImageGray)image).width);
        this.countsB.reserve(((ImageGray)image).width);
        this.connectAtoB.reserve(((ImageGray)image).width);
        this.merge.resize(((ImageGray)image).width);
    }

    protected abstract int labelRow(int var1, int[] var2, int[] var3, int[] var4);

    protected abstract void findConnectionsBetweenRows(int var1, int var2);

    protected final int traverseToEnd(int labelB) {
        int targetB = labelB;
        while (this.merge.data[targetB] != -1) {
            targetB = this.merge.data[targetB];
        }
        return targetB;
    }

    final void mergeClustersInB() {
        for (int i = 0; i < this.labelsB.size; ++i) {
            int label = this.labelsB.data[i];
            if (label == -1 || this.merge.data[label] == -1) continue;
            this.labelsB.data[i] = this.traverseToEnd(label);
        }
        for (int label = 0; label < this.countsB.size; ++label) {
            int target;
            if (this.merge.data[label] == -1) continue;
            int n = target = this.traverseToEnd(label);
            this.countsB.data[n] = this.countsB.data[n] + this.countsB.data[label];
            this.countsB.data[label] = 0;
        }
    }

    final void addCountsRowAIntoB() {
        this.finished.reset();
        for (int labelA = 0; labelA < this.countsA.size; ++labelA) {
            int labelB = this.connectAtoB.data[labelA];
            if (labelB == -1) {
                if (this.countsA.data[labelA] <= 0) continue;
                this.finished.add(labelA);
                continue;
            }
            int n = labelB = this.traverseToEnd(labelB);
            this.countsB.data[n] = this.countsB.data[n] + this.countsA.data[labelA];
        }
    }

    protected abstract void fillCluster(int var1, int var2, int var3);

    @Override
    public int getTotalFilled() {
        return this.totalFilled;
    }
}

