/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.ellipse;

import boofcv.alg.shapes.edge.BaseIntegralEdge;
import boofcv.struct.image.ImageGray;
import georegression.struct.curve.EllipseRotated_F64;

public class EdgeIntensityEllipse<T extends ImageGray<T>>
extends BaseIntegralEdge<T> {
    private double tangentDistance;
    private int numContourPoints;
    double passThreshold;
    double score;
    public double averageInside;
    public double averageOutside;

    public EdgeIntensityEllipse(double tangentDistance, int numContourPoints, double passThreshold, Class<T> imageType) {
        super(imageType);
        this.tangentDistance = tangentDistance;
        this.numContourPoints = numContourPoints;
        this.passThreshold = passThreshold;
    }

    public boolean process(EllipseRotated_F64 ellipse) {
        if (this.numContourPoints <= 0) {
            this.score = 0.0;
            return true;
        }
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        this.averageInside = 0.0;
        this.averageOutside = 0.0;
        int total = 0;
        for (int contourIndex = 0; contourIndex < this.numContourPoints; ++contourIndex) {
            double theta = (double)contourIndex * Math.PI * 2.0 / (double)this.numContourPoints;
            double ct = Math.cos(theta);
            double st = Math.sin(theta);
            double px = ellipse.center.x + ellipse.a * ct * cphi - ellipse.b * st * sphi;
            double py = ellipse.center.y + ellipse.a * ct * sphi + ellipse.b * st * cphi;
            double edx = ellipse.a * ct * ellipse.b * ellipse.b;
            double edy = ellipse.b * st * ellipse.a * ellipse.a;
            double r = Math.sqrt(edx * edx + edy * edy);
            double dx = (edx /= r) * cphi - (edy /= r) * sphi;
            double dy = edx * sphi + edy * cphi;
            double xin = px - dx * this.tangentDistance;
            double yin = py - dy * this.tangentDistance;
            double xout = px + dx * this.tangentDistance;
            double yout = py + dy * this.tangentDistance;
            if (!this.integral.isInside(xin, yin) || !this.integral.isInside(xout, yout)) continue;
            this.averageInside += this.integral.compute(px, py, xin, yin);
            this.averageOutside += this.integral.compute(px, py, xout, yout);
            ++total;
        }
        this.score = 0.0;
        if (total > 0) {
            this.score = Math.abs(this.averageOutside - this.averageInside) / ((double)total * this.tangentDistance);
        }
        return this.score >= this.passThreshold;
    }

    public double getEdgeIntensity() {
        return this.score;
    }
}

