/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.PerspectiveOps;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.ArrayList;
import java.util.Comparator;
import org.ddogleg.struct.DogArray_I32;

public class PruneStructureFromSceneProjective {
    SceneStructureProjective structure;
    SceneObservations observations;

    public PruneStructureFromSceneProjective(SceneStructureProjective structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
    }

    public void pruneObservationsByErrorRank(double inlierFraction) {
        int index0;
        Point2D_F64 observation = new Point2D_F64();
        Point2D_F64 predicted = new Point2D_F64();
        Point3D_F64 X3 = new Point3D_F64();
        Point4D_F64 X4 = new Point4D_F64();
        ArrayList<Errors> errors = new ArrayList<Errors>();
        for (int viewIndex = 0; viewIndex < this.observations.views.size; ++viewIndex) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            SceneStructureProjective.View view = ((SceneStructureProjective.View[])this.structure.views.data)[viewIndex];
            int indexInView = 0;
            while (indexInView < v.point.size) {
                int pointID = v.point.data[indexInView];
                SceneStructureCommon.Point f = ((SceneStructureCommon.Point[])this.structure.points.data)[pointID];
                v.get(indexInView, observation);
                if (this.structure.homogenous) {
                    f.get(X4);
                    PerspectiveOps.renderPixel(view.worldToView, X4, predicted);
                } else {
                    f.get(X3);
                    PerspectiveOps.renderPixel(view.worldToView, X3, predicted);
                }
                Errors e = new Errors();
                e.view = viewIndex;
                e.pointIndexInView = indexInView++;
                e.error = predicted.distance2((GeoTuple2D_F64)observation);
                errors.add(e);
            }
        }
        errors.sort(Comparator.comparingDouble(a -> a.error));
        for (int i = index0 = (int)((double)errors.size() * inlierFraction + 0.5); i < errors.size(); ++i) {
            Errors e = (Errors)errors.get(i);
            SceneObservations.View v = ((SceneObservations.View[])this.observations.views.data)[e.view];
            v.setPixel(e.pointIndexInView, Float.NaN, Float.NaN);
        }
        this.removeMarkedObservations();
    }

    public boolean prunePoints(int count) {
        int i;
        int[] oldToNew = new int[this.structure.points.size];
        DogArray_I32 removeIdx = new DogArray_I32();
        for (int pointIdx = 0; pointIdx < this.structure.points.size; ++pointIdx) {
            SceneStructureCommon.Point sp = ((SceneStructureCommon.Point[])this.structure.points.data)[pointIdx];
            if (sp.views.size < count) {
                removeIdx.add(pointIdx);
                for (i = 0; i < sp.views.size; ++i) {
                    int viewIdx = sp.views.data[i];
                    SceneObservations.View ov = (SceneObservations.View)this.observations.views.get(viewIdx);
                    int localIdx = ov.point.indexOf(pointIdx);
                    if (localIdx == -1) {
                        throw new RuntimeException("Point not in view's observation!?");
                    }
                    ov.remove(localIdx);
                }
                continue;
            }
            oldToNew[pointIdx] = pointIdx - removeIdx.size();
        }
        if (removeIdx.size == 0) {
            return false;
        }
        for (int viewIdx = 0; viewIdx < this.structure.views.size; ++viewIdx) {
            SceneObservations.View so = (SceneObservations.View)this.observations.views.get(viewIdx);
            for (i = 0; i < so.point.size; ++i) {
                so.point.data[i] = oldToNew[so.point.data[i]];
            }
        }
        this.structure.removePoints(removeIdx);
        return true;
    }

    public boolean pruneViews(int count) {
        int i;
        DogArray_I32 viewsIn;
        int pointIdx;
        DogArray_I32 pruneIdx = new DogArray_I32();
        int[] counts = new int[this.structure.views.size];
        for (pointIdx = 0; pointIdx < this.structure.points.size; ++pointIdx) {
            viewsIn = ((SceneStructureCommon.Point[])this.structure.points.data)[pointIdx].views;
            for (i = 0; i < viewsIn.size; ++i) {
                int n = viewsIn.get(i);
                counts[n] = counts[n] + 1;
            }
        }
        for (int viewIdx = 0; viewIdx < this.structure.views.size; ++viewIdx) {
            if (counts[viewIdx] > count) continue;
            pruneIdx.add(viewIdx);
            ((SceneStructureProjective.View[])this.structure.views.data)[viewIdx].width = -2;
        }
        for (pointIdx = 0; pointIdx < this.structure.points.size; ++pointIdx) {
            viewsIn = ((SceneStructureCommon.Point[])this.structure.points.data)[pointIdx].views;
            for (i = viewsIn.size - 1; i >= 0; --i) {
                SceneStructureProjective.View v = ((SceneStructureProjective.View[])this.structure.views.data)[viewsIn.get(i)];
                if (v.width != -2) continue;
                viewsIn.remove(i);
            }
        }
        if (pruneIdx.size() == 0) {
            return false;
        }
        this.structure.views.remove(pruneIdx.data, 0, pruneIdx.size, null);
        this.observations.views.remove(pruneIdx.data, 0, pruneIdx.size, null);
        return true;
    }

    private void removeMarkedObservations() {
        Point2D_F64 observation = new Point2D_F64();
        for (int viewIndex = 0; viewIndex < this.observations.views.size; ++viewIndex) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            for (int indexInView = v.point.size - 1; indexInView >= 0; --indexInView) {
                int pointID = v.getPointId(indexInView);
                SceneStructureCommon.Point f = ((SceneStructureCommon.Point[])this.structure.points.data)[pointID];
                v.get(indexInView, observation);
                if (!Double.isNaN(observation.x)) continue;
                f.removeView(viewIndex);
                v.remove(indexInView);
            }
        }
    }

    private static class Errors {
        int view;
        int pointIndexInView;
        double error;

        private Errors() {
        }
    }
}

