/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.f;

import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.optimization.ResidualsEpipolarMatrix;
import boofcv.alg.geo.ModelObservationResidual;
import boofcv.alg.geo.f.FundamentalResidualSampson;
import boofcv.alg.geo.f.FundamentalResidualSimple;
import boofcv.alg.geo.f.ParamFundamentalEpipolar;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixRMaj;

public class LeastSquaresFundamental
implements RefineEpipolar {
    ModelCodec<DMatrixRMaj> paramModel;
    ResidualsEpipolarMatrix func;
    double[] param;
    UnconstrainedLeastSquares<DMatrixRMaj> minimizer;
    int maxIterations;
    double convergenceTol;

    public LeastSquaresFundamental(double convergenceTol, int maxIterations, boolean useSampson) {
        this(new ParamFundamentalEpipolar(), convergenceTol, maxIterations, useSampson);
    }

    public LeastSquaresFundamental(ModelCodec<DMatrixRMaj> paramModel, double convergenceTol, int maxIterations, boolean useSampson) {
        this.paramModel = paramModel;
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.param = new double[paramModel.getParamLength()];
        ModelObservationResidual<DMatrixRMaj, AssociatedPair> residual = useSampson ? new FundamentalResidualSampson() : new FundamentalResidualSimple();
        this.func = new ResidualsEpipolarMatrix(paramModel, residual);
        this.minimizer = FactoryOptimization.levenbergMarquardt(null, (boolean)false);
    }

    public boolean fitModel(List<AssociatedPair> obs, DMatrixRMaj F, DMatrixRMaj refinedF) {
        this.func.setObservations(obs);
        this.paramModel.encode((Object)F, this.param);
        this.minimizer.setFunction((FunctionNtoM)this.func, null);
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)obs.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        this.paramModel.decode(this.minimizer.getParameters(), (Object)refinedF);
        return true;
    }

    public double getFitScore() {
        return this.minimizer.getFunctionValue();
    }
}

