/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.selfcalib;

import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.selfcalib.SelfCalibrationEssentialGuessAndCheck;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTuple;
import boofcv.struct.image.ImageDimension;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;

public class ProjectiveToMetricCameraEssentialGuessAndCheck
implements ProjectiveToMetricCameras {
    final SelfCalibrationEssentialGuessAndCheck selfCalib;
    DMatrixRMaj K = new DMatrixRMaj(3, 3);
    DogArray<AssociatedPair> pairs = new DogArray(AssociatedPair::new);
    DMatrixRMaj F21 = new DMatrixRMaj(3, 3);

    public ProjectiveToMetricCameraEssentialGuessAndCheck(SelfCalibrationEssentialGuessAndCheck selfCalib) {
        this.selfCalib = selfCalib;
    }

    @Override
    public boolean process(List<ImageDimension> dimensions, List<DMatrixRMaj> views, List<AssociatedTuple> observations, MetricCameras metricViews) {
        BoofMiscOps.checkTrue((views.size() + 1 == dimensions.size() ? 1 : 0) != 0);
        metricViews.reset();
        this.selfCalib.imageLengthPixels = dimensions.get(0).getMaxLength();
        DMatrixRMaj P2 = views.get(0);
        MultiViewOps.projectiveToFundamental(P2, this.F21);
        MultiViewOps.convertTu(observations, 0, 1, this.pairs);
        if (!this.selfCalib.process(this.F21, P2, this.pairs.toList())) {
            return false;
        }
        DMatrixRMaj H = this.selfCalib.rectifyingHomography;
        ((CameraPinhole)metricViews.intrinsics.grow()).fsetK(this.selfCalib.focalLengthA, this.selfCalib.focalLengthA, 0.0, 0.0, 0.0, -1, -1);
        ((CameraPinhole)metricViews.intrinsics.grow()).fsetK(this.selfCalib.focalLengthB, this.selfCalib.focalLengthB, 0.0, 0.0, 0.0, -1, -1);
        PerspectiveOps.pinholeToMatrix((CameraPinhole)metricViews.intrinsics.get(1), this.K);
        if (!MultiViewOps.projectiveToMetricKnownK(P2, H, this.K, (Se3_F64)metricViews.motion_1_to_k.grow())) {
            return false;
        }
        for (int viewIdx = 1; viewIdx < views.size(); ++viewIdx) {
            if (!MultiViewOps.projectiveToMetric(views.get(viewIdx), H, (Se3_F64)metricViews.motion_1_to_k.grow(), this.K)) {
                return false;
            }
            PerspectiveOps.matrixToPinhole(this.K, -1, -1, (CameraPinhole)metricViews.intrinsics.grow());
        }
        return true;
    }

    @Override
    public int getMinimumViews() {
        return 2;
    }

    public SelfCalibrationEssentialGuessAndCheck getSelfCalib() {
        return this.selfCalib;
    }
}

