/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.cloud;

import boofcv.struct.Point3dRgbI_F32;
import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.ConvertFloatType;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import java.util.List;

public interface PointCloudReader {
    public int size();

    public void get(int var1, Point3D_F32 var2);

    public void get(int var1, Point3D_F64 var2);

    public int getRGB(int var1);

    public static PointCloudReader wrap3FRGB(final float[] cloud, final float[] rgb, final int offset, final int length) {
        return new PointCloudReader(){

            @Override
            public int size() {
                return length;
            }

            @Override
            public void get(int index, Point3D_F32 point) {
                int i = offset + index * 3;
                point.setTo(cloud[i], cloud[i + 1], cloud[i + 2]);
            }

            @Override
            public void get(int index, Point3D_F64 point) {
                int i = offset + index * 3;
                point.setTo((double)cloud[i], (double)cloud[i + 1], (double)cloud[i + 2]);
            }

            @Override
            public int getRGB(int index) {
                int i = offset + index * 3;
                int r = (int)(rgb[i] * 255.0f);
                int g = (int)(rgb[i + 1] * 255.0f);
                int b = (int)(rgb[i + 2] * 255.0f);
                return r << 16 | g << 8 | b;
            }
        };
    }

    public static PointCloudReader wrapF32(final List<Point3D_F32> cloud) {
        return new PointCloudReader(){

            @Override
            public int size() {
                return cloud.size();
            }

            @Override
            public void get(int index, Point3D_F32 point) {
                point.setTo((Point3D_F32)cloud.get(index));
            }

            @Override
            public void get(int index, Point3D_F64 point) {
                ConvertFloatType.convert((Point3D_F32)((Point3D_F32)cloud.get(index)), (Point3D_F64)point);
            }

            @Override
            public int getRGB(int index) {
                return 0;
            }
        };
    }

    public static PointCloudReader wrapF64(final List<Point3D_F64> cloud) {
        return new PointCloudReader(){

            @Override
            public int size() {
                return cloud.size();
            }

            @Override
            public void get(int index, Point3D_F32 point) {
                ConvertFloatType.convert((Point3D_F64)((Point3D_F64)cloud.get(index)), (Point3D_F32)point);
            }

            @Override
            public void get(int index, Point3D_F64 point) {
                point.setTo((Point3D_F64)cloud.get(index));
            }

            @Override
            public int getRGB(int index) {
                return 0;
            }
        };
    }

    public static PointCloudReader wrapF32RGB(final List<Point3dRgbI_F32> cloud) {
        return new PointCloudReader(){

            @Override
            public int size() {
                return cloud.size();
            }

            @Override
            public void get(int index, Point3D_F32 point) {
                point.setTo((Point3D_F32)cloud.get(index));
            }

            @Override
            public void get(int index, Point3D_F64 point) {
                ConvertFloatType.convert((Point3D_F32)((Point3D_F32)cloud.get(index)), (Point3D_F64)point);
            }

            @Override
            public int getRGB(int index) {
                return ((Point3dRgbI_F32)cloud.get((int)index)).rgb;
            }
        };
    }

    public static PointCloudReader wrapF64RGB(final List<Point3dRgbI_F64> cloud) {
        return new PointCloudReader(){

            @Override
            public int size() {
                return cloud.size();
            }

            @Override
            public void get(int index, Point3D_F32 point) {
                ConvertFloatType.convert((Point3D_F64)((Point3D_F64)cloud.get(index)), (Point3D_F32)point);
            }

            @Override
            public void get(int index, Point3D_F64 point) {
                point.setTo((Point3D_F64)cloud.get(index));
            }

            @Override
            public int getRGB(int index) {
                return ((Point3dRgbI_F64)cloud.get((int)index)).rgb;
            }
        };
    }
}

