/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.struct.ImageRectangle_F32;
import boofcv.struct.ImageRectangle_F64;
import boofcv.struct.distort.PixelTransform;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.RectangleLength2D_F32;
import georegression.struct.shapes.RectangleLength2D_F64;
import georegression.struct.shapes.RectangleLength2D_I32;

public class DistortImageOps {
    public static RectangleLength2D_I32 boundBox(int srcWidth, int srcHeight, int dstWidth, int dstHeight, Point2D_F32 work, PixelTransform<Point2D_F32> transform) {
        RectangleLength2D_I32 ret = DistortImageOps.boundBox(srcWidth, srcHeight, work, transform);
        int x0 = ret.x0;
        int y0 = ret.y0;
        int x1 = ret.x0 + ret.width;
        int y1 = ret.y0 + ret.height;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > dstWidth) {
            x1 = dstWidth;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > dstHeight) {
            y1 = dstHeight;
        }
        return new RectangleLength2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_I32 boundBox(int srcWidth, int srcHeight, Point2D_F32 work, PixelTransform<Point2D_F32> transform) {
        int y1;
        int x1;
        transform.compute(0, 0, (Object)work);
        int x0 = x1 = (int)work.x;
        int y0 = y1 = (int)work.y;
        for (int i = 1; i < 4; ++i) {
            if (i == 1) {
                transform.compute(srcWidth, 0, (Object)work);
            } else if (i == 2) {
                transform.compute(0, srcHeight, (Object)work);
            } else if (i == 3) {
                transform.compute(srcWidth - 1, srcHeight, (Object)work);
            }
            if (work.x < (float)x0) {
                x0 = (int)work.x;
            } else if (work.x > (float)x1) {
                x1 = (int)work.x;
            }
            if (work.y < (float)y0) {
                y0 = (int)work.y;
                continue;
            }
            if (!(work.y > (float)y1)) continue;
            y1 = (int)work.y;
        }
        return new RectangleLength2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_F32 boundBox_F32(int srcWidth, int srcHeight, PixelTransform<Point2D_F32> transform, Point2D_F32 transformed) {
        ImageRectangle_F32 r = new ImageRectangle_F32();
        r.y0 = Float.MAX_VALUE;
        r.x0 = Float.MAX_VALUE;
        r.y1 = -3.4028235E38f;
        r.x1 = -3.4028235E38f;
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(srcWidth - 1, y, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(x, srcHeight - 1, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        return new RectangleLength2D_F32(r.x0, r.y0, 1.0f + r.x1 - r.x0, 1.0f + r.y1 - r.y0);
    }

    private static void updateBoundBox(Point2D_F32 p, ImageRectangle_F32 r) {
        if (p.x < r.x0) {
            r.x0 = p.x;
        } else if (p.x > r.x1) {
            r.x1 = p.x;
        }
        if (p.y < r.y0) {
            r.y0 = p.y;
        } else if (p.y > r.y1) {
            r.y1 = p.y;
        }
    }

    public static RectangleLength2D_F64 boundBox_F64(int srcWidth, int srcHeight, PixelTransform<Point2D_F64> transform, Point2D_F64 transformed) {
        ImageRectangle_F64 r = new ImageRectangle_F64();
        r.y0 = Double.MAX_VALUE;
        r.x0 = Double.MAX_VALUE;
        r.y1 = -1.7976931348623157E308;
        r.x1 = -1.7976931348623157E308;
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(srcWidth - 1, y, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(x, srcHeight - 1, (Object)transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        return new RectangleLength2D_F64(r.x0, r.y0, 1.0 + r.x1 - r.x0, 1.0 + r.y1 - r.y0);
    }

    private static void updateBoundBox(Point2D_F64 transform, ImageRectangle_F64 r) {
        if (transform.x < r.x0) {
            r.x0 = transform.x;
        } else if (transform.x > r.x1) {
            r.x1 = transform.x;
        }
        if (transform.y < r.y0) {
            r.y0 = transform.y;
        } else if (transform.y > r.y1) {
            r.y1 = transform.y;
        }
    }
}

