/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.brown;

import boofcv.alg.distort.brown.RadialTangential_F64;
import boofcv.alg.distort.brown.RemoveBrownNtoN_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F64;

public class RemoveBrownPtoN_F64
implements Point2Transform2_F64 {
    protected double cx;
    protected double cy;
    protected double fx;
    protected double fy;
    protected double skew;
    protected RadialTangential_F64 params;
    private double a11;
    private double a12;
    private double a13;
    private double a22;
    private double a23;
    private double tol = GrlConstants.DCONV_TOL_A;

    public RemoveBrownPtoN_F64() {
    }

    public RemoveBrownPtoN_F64(double tol) {
        this.tol = tol;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    public RemoveBrownPtoN_F64 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.a11 = 1.0 / fx;
        this.a12 = -skew / (fx * fy);
        this.a13 = (skew * cy - cx * fy) / (fx * fy);
        this.a22 = 1.0 / fy;
        this.a23 = -cy / fy;
        return this;
    }

    public RemoveBrownPtoN_F64 setDistortion(double[] radial, double t1, double t2) {
        if (this.params != null && this.params.radial.length == radial.length) {
            System.arraycopy(radial, 0, this.params.radial, 0, radial.length);
            return this;
        }
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    public RemoveBrownPtoN_F64 setDistortion(double radial1, double radial2) {
        if (this.params != null && this.params.radial.length == 2) {
            this.params.radial[0] = radial1;
            this.params.radial[1] = radial2;
            return this;
        }
        this.params = new RadialTangential_F64(new double[]{radial1, radial2}, 0.0, 0.0);
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        out.x = this.a11 * x + this.a12 * y + this.a13;
        out.y = this.a22 * y + this.a23;
        RemoveBrownNtoN_F64.removeRadial(out.x, out.y, this.params.radial, this.params.t1, this.params.t2, out, this.tol);
    }

    public RemoveBrownPtoN_F64 copyConcurrent() {
        RemoveBrownPtoN_F64 ret = new RemoveBrownPtoN_F64(this.tol);
        ret.fx = this.fx;
        ret.fy = this.fy;
        ret.skew = this.skew;
        ret.cx = this.cx;
        ret.cy = this.cy;
        ret.a11 = this.a11;
        ret.a12 = this.a12;
        ret.a13 = this.a13;
        ret.a22 = this.a22;
        ret.a23 = this.a23;
        ret.params = new RadialTangential_F64(this.params);
        return ret;
    }
}

