/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class DecomposeProjectiveToMetric {
    protected QRDecomposition<DMatrixRMaj> qr = DecompositionFactory_DDRM.qr((int)3, (int)3);
    protected DMatrixRMaj Pv = SpecializedOps_DDRM.pivotMatrix(null, (int[])new int[]{2, 1, 0}, (int)3, (boolean)false);
    protected DMatrixRMaj A_p = new DMatrixRMaj(3, 3);
    protected DMatrixRMaj A = new DMatrixRMaj(3, 3);
    protected SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((boolean)true, (boolean)true, (boolean)true);
    protected DMatrixRMaj P_metric = new DMatrixRMaj(3, 4);
    protected DMatrixRMaj P_rt = new DMatrixRMaj(3, 4);
    protected DMatrixRMaj K_inv = new DMatrixRMaj(3, 3);
    public double singularError;

    public boolean projectiveToMetricKnownK(DMatrixRMaj cameraMatrix, DMatrixRMaj H, DMatrixRMaj K, Se3_F64 worldToView) {
        this.singularError = 0.0;
        CommonOps_DDRM.mult((DMatrix1Row)cameraMatrix, (DMatrix1Row)H, (DMatrix1Row)this.P_metric);
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)this.K_inv);
        CommonOps_DDRM.mult((DMatrix1Row)this.K_inv, (DMatrix1Row)this.P_metric, (DMatrix1Row)this.P_rt);
        CommonOps_DDRM.extract((DMatrix)this.P_rt, (int)0, (int)0, (DMatrix)worldToView.R);
        worldToView.T.x = this.P_rt.get(0, 3);
        worldToView.T.y = this.P_rt.get(1, 3);
        worldToView.T.z = this.P_rt.get(2, 3);
        DMatrixRMaj R = worldToView.R;
        if (!this.svd.decompose((Matrix)R)) {
            return false;
        }
        CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrixRMaj)this.svd.getU(null, false)), (DMatrix1Row)((DMatrixRMaj)this.svd.getV(null, false)), (DMatrix1Row)R);
        double det = CommonOps_DDRM.det((DMatrixRMaj)R);
        if (det < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)R);
            worldToView.T.scale(-1.0);
        }
        double[] sv = this.svd.getSingularValues();
        double sv_mag = (sv[0] + sv[1] + sv[2]) / 3.0;
        worldToView.T.divideIP(sv_mag);
        for (int i = 0; i < 3; ++i) {
            this.singularError += Math.abs(sv[i] - sv_mag);
        }
        return true;
    }

    public boolean projectiveToMetric(DMatrixRMaj cameraMatrix, DMatrixRMaj H, Se3_F64 worldToView, DMatrixRMaj K) {
        CommonOps_DDRM.mult((DMatrix1Row)cameraMatrix, (DMatrix1Row)H, (DMatrix1Row)this.P_metric);
        return this.decomposeMetricCamera(this.P_metric, K, worldToView);
    }

    public boolean decomposeMetricCamera(DMatrixRMaj cameraMatrix, DMatrixRMaj K, Se3_F64 worldToView) {
        CommonOps_DDRM.extract((DMatrix)cameraMatrix, (int)0, (int)3, (int)0, (int)3, (DMatrix)this.A, (int)0, (int)0);
        worldToView.T.setTo(cameraMatrix.get(0, 3), cameraMatrix.get(1, 3), cameraMatrix.get(2, 3));
        CommonOps_DDRM.mult((DMatrix1Row)this.Pv, (DMatrix1Row)this.A, (DMatrix1Row)this.A_p);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.A_p);
        if (!this.qr.decompose((Matrix)this.A_p)) {
            return false;
        }
        this.qr.getQ((Matrix)this.A, false);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.Pv, (DMatrix1Row)this.A, (DMatrix1Row)worldToView.R);
        this.qr.getR((Matrix)K, false);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.Pv, (DMatrix1Row)K, (DMatrix1Row)this.A);
        CommonOps_DDRM.mult((DMatrix1Row)this.A, (DMatrix1Row)this.Pv, (DMatrix1Row)K);
        for (int i = 0; i < 3; ++i) {
            if (!(K.get(i, i) < 0.0)) continue;
            CommonOps_DDRM.scaleCol((double)-1.0, (DMatrixRMaj)K, (int)i);
            CommonOps_DDRM.scaleRow((double)-1.0, (DMatrixRMaj)worldToView.R, (int)i);
        }
        if (CommonOps_DDRM.det((DMatrixRMaj)worldToView.R) < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)worldToView.R);
            worldToView.T.scale(-1.0);
        }
        double scale = K.get(2, 2);
        CommonOps_DDRM.divide((DMatrixD1)K, (double)scale);
        if (!CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)this.A)) {
            return false;
        }
        GeometryMath_F64.mult((DMatrixRMaj)this.A, (GeoTuple3D_F64)worldToView.T, (GeoTuple3D_F64)worldToView.T);
        worldToView.T.divide(scale);
        return true;
    }

    public double getSingularError() {
        return this.singularError;
    }
}

