/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CalibrationObservation {
    int width;
    int height;
    public List<PointIndex2D_F64> points = new ArrayList<PointIndex2D_F64>();

    public CalibrationObservation(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public CalibrationObservation() {
    }

    public void setTo(CalibrationObservation obs) {
        this.reset();
        this.width = obs.width;
        this.height = obs.height;
        for (int i = 0; i < obs.size(); ++i) {
            PointIndex2D_F64 p = obs.points.get(i);
            this.points.add(p.copy());
        }
    }

    public PointIndex2D_F64 get(int index) {
        return this.points.get(index);
    }

    public void add(Point2D_F64 observation, int which) {
        this.points.add(new PointIndex2D_F64(observation, which));
    }

    public void add(double x, double y, int which) {
        this.points.add(new PointIndex2D_F64(x, y, which));
    }

    public void reset() {
        this.points.clear();
        this.width = 0;
        this.height = 0;
    }

    public void sort() {
        Collections.sort(this.points, Comparator.comparingInt(o -> o.index));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int size() {
        return this.points.size();
    }

    public List<PointIndex2D_F64> getPoints() {
        return this.points;
    }

    public CalibrationObservation copy() {
        CalibrationObservation c = new CalibrationObservation();
        c.setTo(this);
        return c;
    }
}

