/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.LinearSolverSafe;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class HomographyInducedStereo3Pts {
    private final Point3D_F64 e2 = new Point3D_F64();
    private final DMatrixRMaj H = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj A = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj M = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj temp0 = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj temp1 = new DMatrixRMaj(3, 1);
    private final Point3D_F64 A_inv_b = new Point3D_F64();
    private final Point3D_F64 Ax = new Point3D_F64();
    private final Point3D_F64 b = new Point3D_F64();
    private final Point3D_F64 t0 = new Point3D_F64();
    private final Point3D_F64 t1 = new Point3D_F64();
    private final LinearSolverDense<DMatrixRMaj> solver;
    private final AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();

    public HomographyInducedStereo3Pts() {
        this.solver = new LinearSolverSafe(LinearSolverFactory_DDRM.linear((int)3));
    }

    public void setFundamental(DMatrixRMaj F, Point3D_F64 e2) {
        if (e2 != null) {
            this.e2.setTo(e2);
        } else {
            MultiViewOps.extractEpipoles(F, new Point3D_F64(), this.e2);
        }
        GeometryMath_F64.multCrossA((GeoTuple3D_F64)this.e2, (DMatrixRMaj)F, (DMatrixRMaj)this.A);
    }

    public boolean process(AssociatedPair p1, AssociatedPair p2, AssociatedPair p3) {
        this.fillM(p1.p1, p2.p1, p3.p1);
        this.b.x = this.computeB(p1.p2);
        this.b.y = this.computeB(p2.p2);
        this.b.z = this.computeB(p3.p2);
        if (!this.solver.setA((Matrix)this.M)) {
            return false;
        }
        GeometryMath_F64.toMatrix((GeoTuple3D_F64)this.b, (DMatrixRMaj)this.temp0);
        this.solver.solve((Matrix)this.temp0, (Matrix)this.temp1);
        GeometryMath_F64.toTuple3D((DMatrixRMaj)this.temp1, (GeoTuple3D_F64)this.A_inv_b);
        GeometryMath_F64.addOuterProd((DMatrixRMaj)this.A, (double)-1.0, (GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.A_inv_b, (DMatrixRMaj)this.H);
        this.adjust.adjust(this.H, p1);
        return true;
    }

    private void fillM(Point2D_F64 x1, Point2D_F64 x2, Point2D_F64 x3) {
        this.M.data[0] = x1.x;
        this.M.data[1] = x1.y;
        this.M.data[2] = 1.0;
        this.M.data[3] = x2.x;
        this.M.data[4] = x2.y;
        this.M.data[5] = 1.0;
        this.M.data[6] = x3.x;
        this.M.data[7] = x3.y;
        this.M.data[8] = 1.0;
    }

    private double computeB(Point2D_F64 x) {
        GeometryMath_F64.mult((DMatrixRMaj)this.A, (GeoTuple2D_F64)x, (GeoTuple3D_F64)this.Ax);
        GeometryMath_F64.cross((GeoTuple2D_F64)x, (GeoTuple3D_F64)this.Ax, (GeoTuple3D_F64)this.t0);
        GeometryMath_F64.cross((GeoTuple2D_F64)x, (GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.t1);
        double top = GeometryMath_F64.dot((GeoTuple3D_F64)this.t0, (GeoTuple3D_F64)this.t1);
        double bottom = this.t1.normSq();
        return top / bottom;
    }

    public DMatrixRMaj getHomography() {
        return this.H;
    }
}

