/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceMetricTripleReprojection23
implements DistanceFromModel<MetricCameraTriple, AssociatedTriple> {
    protected MetricCameraTriple model;
    protected TriangulateNViewsMetric triangulate = FactoryMultiView.triangulateNViewMetric(null);
    private final Point2D_F64 norm1 = new Point2D_F64();
    private final Point2D_F64 norm2 = new Point2D_F64();
    private final Point2D_F64 norm3 = new Point2D_F64();
    private final Point2D_F64 pixel = new Point2D_F64();
    private final Point3D_F64 X = new Point3D_F64();
    private final Point3D_F64 Xcam = new Point3D_F64();
    private final PinholePtoN_F64 pixelToNorm1 = new PinholePtoN_F64();
    private final PinholePtoN_F64 pixelToNorm2 = new PinholePtoN_F64();
    private final PinholePtoN_F64 pixelToNorm3 = new PinholePtoN_F64();
    Se3_F64 view_1_to_1 = new Se3_F64();
    List<Point2D_F64> observations = new ArrayList<Point2D_F64>();
    List<Se3_F64> locations = new ArrayList<Se3_F64>();

    public DistanceMetricTripleReprojection23() {
        this.observations.add(this.norm1);
        this.observations.add(this.norm2);
        this.observations.add(this.norm3);
    }

    public void setModel(MetricCameraTriple model) {
        this.model = model;
        this.pixelToNorm1.setK(model.view1);
        this.pixelToNorm2.setK(model.view2);
        this.pixelToNorm3.setK(model.view3);
        this.locations.clear();
        this.locations.add(this.view_1_to_1);
        this.locations.add(model.view_1_to_2);
        this.locations.add(model.view_1_to_3);
    }

    public double distance(AssociatedTriple obs) {
        this.pixelToNorm1.compute(obs.p1.x, obs.p1.y, this.norm1);
        this.pixelToNorm2.compute(obs.p2.x, obs.p2.y, this.norm2);
        this.pixelToNorm3.compute(obs.p3.x, obs.p3.y, this.norm3);
        if (!this.triangulate.triangulate(this.observations, this.locations, this.X) || this.X.z < 0.0) {
            return Double.MAX_VALUE;
        }
        SePointOps_F64.transform((Se3_F64)this.model.view_1_to_3, (Point3D_F64)this.X, (Point3D_F64)this.Xcam);
        if (this.Xcam.z < 0.0) {
            return Double.MAX_VALUE;
        }
        PerspectiveOps.renderPixel(this.model.view3, this.Xcam, this.pixel);
        double error = this.pixel.distance2((GeoTuple2D_F64)obs.p3);
        SePointOps_F64.transform((Se3_F64)this.model.view_1_to_2, (Point3D_F64)this.X, (Point3D_F64)this.Xcam);
        if (this.X.z < 0.0) {
            return Double.MAX_VALUE;
        }
        PerspectiveOps.renderPixel(this.model.view2, this.Xcam, this.pixel);
        return error + this.pixel.distance2((GeoTuple2D_F64)obs.p2);
    }

    public void distances(List<AssociatedTriple> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.distance(observations.get(i));
        }
    }

    public Class<AssociatedTriple> getPointType() {
        return AssociatedTriple.class;
    }

    public Class<MetricCameraTriple> getModelType() {
        return MetricCameraTriple.class;
    }

    public TriangulateNViewsMetric getTriangulate() {
        return this.triangulate;
    }

    public void setTriangulate(TriangulateNViewsMetric triangulate) {
        this.triangulate = triangulate;
    }
}

