/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.selfcalib.EstimatePlaneAtInfinityGivenK;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import georegression.struct.point.Vector3D_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class SelfCalibrationPraticalGuessAndCheckFocus
implements VerbosePrint {
    boolean fixedFocus;
    double sampleMin = 0.3;
    double sampleMax = 3.0;
    int numSamples = 50;
    DogArray<DMatrixRMaj> normalizedP;
    EstimatePlaneAtInfinityGivenK estimatePlaneInf = new EstimatePlaneAtInfinityGivenK();
    Vector3D_F64 planeInf = new Vector3D_F64();
    DMatrixRMaj K1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj P1 = new DMatrixRMaj(3, 4);
    DMatrixRMaj tmpP = new DMatrixRMaj(3, 4);
    DMatrixRMaj H = new DMatrixRMaj(4, 4);
    DMatrixRMaj bestH = new DMatrixRMaj(4, 4);
    DMatrixRMaj Q = new DMatrixRMaj(4, 4);
    DMatrixRMaj V = new DMatrixRMaj(3, 3);
    DMatrixRMaj Vinv = new DMatrixRMaj(3, 3);
    double[] scores = new double[this.numSamples];
    double w_sk = 100.0;
    double w_ar = 5.0;
    double w_uo = 10.0;
    CameraPinhole intrinsic = new CameraPinhole();
    DMatrixRMaj tmp = new DMatrixRMaj(3, 3);
    boolean localMinimum;
    PrintStream verbose;

    public SelfCalibrationPraticalGuessAndCheckFocus() {
        this.normalizedP = new DogArray(() -> new DMatrixRMaj(3, 4));
    }

    public void setCamera(double skew, double cx, double cy, int width, int height) {
        double d = Math.sqrt(width * width + height * height);
        this.V.zero();
        this.V.set(0, 0, d / 2.0);
        this.V.set(0, 1, skew);
        this.V.set(0, 2, cx);
        this.V.set(1, 1, d / 2.0);
        this.V.set(1, 2, cy);
        this.V.set(2, 2, 1.0);
        CommonOps_DDRM.invert((DMatrixRMaj)this.V, (DMatrixRMaj)this.Vinv);
    }

    public void setSampling(double min, double max, int total) {
        this.sampleMin = min;
        this.sampleMax = max;
        this.numSamples = total;
        this.scores = new double[this.numSamples];
    }

    public boolean process(List<DMatrixRMaj> cameraMatrices) {
        BoofMiscOps.checkTrue((this.V.data[0] != 0.0 ? 1 : 0) != 0, (String)"Must call setCamera()");
        BoofMiscOps.checkTrue((cameraMatrices.size() > 0 ? 1 : 0) != 0, (String)"'cameraMatrices' contain at least 1 matrix");
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.tmpP);
        CommonOps_DDRM.mult((DMatrix1Row)this.Vinv, (DMatrix1Row)this.tmpP, (DMatrix1Row)this.P1);
        MultiViewOps.projectiveToIdentityH(this.P1, this.H);
        this.normalizedP.reset();
        for (int i = 0; i < cameraMatrices.size(); ++i) {
            DMatrixRMaj A = cameraMatrices.get(i);
            DMatrixRMaj Pi = (DMatrixRMaj)this.normalizedP.grow();
            CommonOps_DDRM.mult((DMatrix1Row)this.Vinv, (DMatrix1Row)A, (DMatrix1Row)this.tmpP);
            CommonOps_DDRM.mult((DMatrix1Row)this.tmpP, (DMatrix1Row)this.H, (DMatrix1Row)Pi);
            double a0 = Pi.get(2, 0);
            double a1 = Pi.get(2, 1);
            double a2 = Pi.get(2, 2);
            double scale = Math.sqrt(a0 * a0 + a1 * a1 + a2 * a2);
            CommonOps_DDRM.scale((double)(1.0 / scale), (DMatrixD1)Pi);
        }
        double bestScore = this.fixedFocus ? this.findBestFocusOne((DMatrixRMaj)this.normalizedP.get(0)) : this.findBestFocusTwo((DMatrixRMaj)this.normalizedP.get(0));
        CommonOps_DDRM.extract((DMatrix)this.bestH, (int)0, (int)0, (DMatrix)this.tmp);
        CommonOps_DDRM.mult((DMatrix1Row)this.V, (DMatrix1Row)this.tmp, (DMatrix1Row)this.K1);
        CommonOps_DDRM.insert((DMatrix)this.K1, (DMatrix)this.bestH, (int)0, (int)0);
        return bestScore != Double.MAX_VALUE && this.localMinimum;
    }

    private double findBestFocusOne(DMatrixRMaj P2) {
        this.localMinimum = false;
        double b = Math.log(this.sampleMax / this.sampleMin) / (double)(this.numSamples - 1);
        double bestScore = Double.MAX_VALUE;
        int bestIndex = -1;
        for (int i = 0; i < this.numSamples; ++i) {
            double score;
            double f = this.sampleMin * Math.exp(b * (double)i);
            if (!this.computeRectifyH(f, f, P2, this.H)) {
                this.scores[i] = Double.NaN;
                continue;
            }
            MultiViewOps.rectifyHToAbsoluteQuadratic(this.H, this.Q);
            this.scores[i] = score = this.scoreResults();
            if (score < bestScore) {
                bestScore = score;
                this.bestH.set((DMatrixD1)this.H);
                bestIndex = i;
            }
            if (this.verbose == null) continue;
            this.verbose.printf("[%3d] f=%5.2f score=%f\n", i, f, score);
        }
        if (bestIndex > 0 && bestIndex < this.numSamples - 1) {
            this.localMinimum = bestScore < this.scores[bestIndex - 1] && bestScore < this.scores[bestIndex + 1];
        }
        return bestScore;
    }

    private double findBestFocusTwo(DMatrixRMaj P2) {
        this.localMinimum = false;
        double b = Math.log(this.sampleMax / this.sampleMin) / (double)(this.numSamples - 1);
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < this.numSamples; ++i) {
            double f1 = this.sampleMin * Math.exp(b * (double)i);
            boolean minimumChanged = false;
            int bestIndex = -1;
            for (int j = 0; j < this.numSamples; ++j) {
                double score;
                double f2 = this.sampleMin * Math.exp(b * (double)j);
                if (!this.computeRectifyH(f1, f2, P2, this.H)) {
                    this.scores[i] = Double.NaN;
                    continue;
                }
                MultiViewOps.rectifyHToAbsoluteQuadratic(this.H, this.Q);
                this.scores[j] = score = this.scoreResults();
                if (score < bestScore) {
                    minimumChanged = true;
                    bestIndex = j;
                    bestScore = score;
                    this.bestH.set((DMatrixD1)this.H);
                }
                if (this.verbose == null) continue;
                this.verbose.printf("[%3d,%3d] f1=%5.2f f2=%5.2f score=%f\n", i, j, f1, f2, score);
            }
            if (!minimumChanged) continue;
            this.localMinimum = bestIndex > 0 && bestIndex < this.numSamples - 1 ? bestScore < this.scores[bestIndex - 1] && bestScore < this.scores[bestIndex + 1] : false;
        }
        return bestScore;
    }

    boolean computeRectifyH(double f1, double f2, DMatrixRMaj P2, DMatrixRMaj H) {
        this.estimatePlaneInf.setCamera1(f1, f1, 0.0, 0.0, 0.0);
        this.estimatePlaneInf.setCamera2(f2, f2, 0.0, 0.0, 0.0);
        if (!this.estimatePlaneInf.estimatePlaneAtInfinity(P2, this.planeInf)) {
            return false;
        }
        this.K1.zero();
        this.K1.set(0, 0, f1);
        this.K1.set(1, 1, f1);
        this.K1.set(2, 2, 1.0);
        MultiViewOps.createProjectiveToMetric(this.K1, this.planeInf.x, this.planeInf.y, this.planeInf.z, 1.0, H);
        return true;
    }

    double scoreResults() {
        double totalScore = 0.0;
        for (int i = 0; i < this.normalizedP.size; ++i) {
            DMatrixRMaj P = (DMatrixRMaj)this.normalizedP.get(i);
            MultiViewOps.intrinsicFromAbsoluteQuadratic(this.Q, P, this.intrinsic);
            double score = 0.0;
            score += this.w_sk * Math.abs(this.intrinsic.skew);
            score += this.w_ar * (Math.max(this.intrinsic.fx, this.intrinsic.fy) / Math.min(this.intrinsic.fx, this.intrinsic.fy) - 1.0);
            totalScore += (score += this.w_uo * (Math.abs(this.intrinsic.cx) + Math.abs(this.intrinsic.cy)));
        }
        return totalScore;
    }

    public boolean isFixedFocus() {
        return this.fixedFocus;
    }

    public void setSingleCamera(boolean sameFocus) {
        this.fixedFocus = sameFocus;
    }

    public DMatrixRMaj getRectifyingHomography() {
        return this.bestH;
    }

    public boolean isLocalMinimum() {
        return this.localMinimum;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }
}

