/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points;

import boofcv.alg.cloud.PointCloudReader;
import boofcv.alg.cloud.PointCloudWriter;
import boofcv.io.points.impl.PlyCodec;
import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class PointCloudIO {
    public static void save3D(Format format, PointCloudReader cloud, boolean saveRGB, OutputStream outputStream) throws IOException {
        switch (format) {
            case PLY: {
                PlyCodec.saveBinary(cloud, ByteOrder.BIG_ENDIAN, saveRGB, false, outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
    }

    public static DogArray<Point3D_F32> load3D32F(Format format, InputStream input, @Nullable DogArray<Point3D_F32> storage) throws IOException {
        if (storage == null) {
            storage = new DogArray(Point3D_F32::new);
        }
        PointCloudWriter output = PointCloudWriter.wrapF32(storage);
        PointCloudIO.load(format, input, output);
        return storage;
    }

    public static DogArray<Point3D_F64> load3D64F(Format format, InputStream input, @Nullable DogArray<Point3D_F64> storage) throws IOException {
        if (storage == null) {
            storage = new DogArray(Point3D_F64::new);
        }
        PointCloudWriter output = PointCloudWriter.wrapF64(storage);
        PointCloudIO.load(format, input, output);
        return storage;
    }

    public static DogArray<Point3dRgbI_F64> load3DRgb64F(Format format, InputStream input, @Nullable DogArray<Point3dRgbI_F64> storage) throws IOException {
        if (storage == null) {
            storage = new DogArray(Point3dRgbI_F64::new);
        }
        PointCloudWriter output = PointCloudWriter.wrapF64RGB(storage);
        PointCloudIO.load(format, input, output);
        return storage;
    }

    public static void load(Format format, InputStream input, PointCloudWriter output) throws IOException {
        switch (format) {
            case PLY: {
                PlyCodec.read(input, output);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
    }

    public static enum Format {
        PLY;

    }
}

