/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.images;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;

public class BufferedFileImageSequence<T extends ImageBase<T>>
implements SimpleImageSequence<T> {
    BufferedImage[] orig;
    T[] images;
    int index;
    BufferedImage imageGUI;
    T image;
    ImageType<T> type;
    boolean loop = true;
    boolean forwards = true;

    public BufferedFileImageSequence(ImageType<T> type, File directory, String suffix) {
        this.type = type;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory must specify a directory");
        }
        String[] files = directory.list(new Filter(suffix));
        ArrayList<String> listNames = new ArrayList<String>();
        for (String s : files) {
            listNames.add(s);
        }
        Collections.sort(listNames);
        this.orig = new BufferedImage[files.length];
        this.images = type.createArray(files.length);
        int index = 0;
        for (String s : listNames) {
            BufferedImage b = this.orig[index] = UtilImageIO.loadImage(directory.getPath() + "/" + s);
            int n = index++;
            ImageBase imageBase = type.createImage(b.getWidth(), b.getHeight());
            this.images[n] = imageBase;
            ImageBase a = imageBase;
            ConvertBufferedImage.convertFrom(b, a, true);
        }
    }

    public BufferedFileImageSequence(ImageType<T> type, BufferedImage[] orig) {
        this.type = type;
        this.orig = orig;
        this.images = type.createArray(orig.length);
        for (int i = 0; i < orig.length; ++i) {
            BufferedImage b = orig[i];
            this.images[i] = type.createImage(b.getWidth(), b.getHeight());
            ConvertBufferedImage.convertFrom(orig[i], this.images[i], true);
        }
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public int getWidth() {
        return this.imageGUI.getWidth();
    }

    @Override
    public int getHeight() {
        return this.imageGUI.getHeight();
    }

    @Override
    public boolean hasNext() {
        if (this.loop) {
            return true;
        }
        return this.index < this.images.length;
    }

    @Override
    public T next() {
        if (this.loop) {
            if (this.forwards) {
                if (this.index >= this.images.length) {
                    this.index = this.images.length - 1;
                    this.forwards = false;
                }
            } else if (this.index < 0) {
                this.index = 0;
                this.forwards = true;
            }
        }
        this.imageGUI = this.orig[this.index];
        this.image = this.forwards ? this.images[this.index++] : this.images[this.index--];
        return this.getImage();
    }

    @Override
    public T getImage() {
        return this.image;
    }

    @Override
    public BufferedImage getGuiImage() {
        return this.imageGUI;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }

    @Override
    public int getFrameNumber() {
        return this.index - 1;
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
        this.index = 0;
        this.forwards = true;
        this.image = null;
        this.imageGUI = null;
    }

    private static class Filter
    implements FilenameFilter {
        String suffix;

        private Filter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this.suffix);
        }
    }
}

