/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.disparity;

import boofcv.abst.disparity.WrapBaseBlockMatch;
import boofcv.abst.filter.FilterImageInterface;
import boofcv.alg.disparity.DisparityBlockMatchRowFormat;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class WrapDisparityBlockMatchCensus<T extends ImageGray<T>, C extends ImageGray<C>, DI extends ImageGray<DI>>
extends WrapBaseBlockMatch<T, C, DI> {
    FilterImageInterface<T, C> censusTran;
    C cleft;
    C cright;

    public WrapDisparityBlockMatchCensus(FilterImageInterface<T, C> censusTran, DisparityBlockMatchRowFormat<C, DI> alg) {
        super(alg);
        this.censusTran = censusTran;
        this.alg = alg;
        this.disparity = GeneralizedImageOps.createSingleBand(alg.getDisparityType(), (int)1, (int)1);
        this.cleft = (ImageGray)censusTran.getOutputType().createImage(1, 1);
        this.cright = (ImageGray)censusTran.getOutputType().createImage(1, 1);
    }

    @Override
    public void _process(T imageLeft, T imageRight) {
        this.censusTran.process(imageLeft, this.cleft);
        this.censusTran.process(imageRight, this.cright);
        this.alg.process(this.cleft, this.cright, this.disparity);
    }

    public C getCLeft() {
        return this.cleft;
    }

    public C getCRight() {
        return this.cright;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.censusTran.getInputType();
    }

    public FilterImageInterface<T, C> getCensusTran() {
        return this.censusTran;
    }
}

