/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block;

import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;

public interface BlockRowScoreCensus {

    public static class S64
    extends BlockRowScore.ArrayS32_BS64 {
        public S64(int maxPerPixel) {
            super(maxPerPixel);
        }

        @Override
        public void score(long[] leftRow, long[] rightRow, int indexLeft, int indexRight, int offset, int length, int[] elementScore) {
            for (int i = 0; i < length; ++i) {
                long a = leftRow[indexLeft++];
                long b = rightRow[indexRight++];
                elementScore[offset + i] = DescriptorDistance.hamming((long)(a ^ b));
            }
        }

        @Override
        public boolean isRequireNormalize() {
            return false;
        }

        @Override
        public ImageType<GrayS64> getImageType() {
            return ImageType.single(GrayS64.class);
        }
    }

    public static class S32
    extends CensusArrayS32_B32<GrayS32, int[]> {
        public S32(int maxPerPixel) {
            super(maxPerPixel);
        }

        @Override
        public void score(int[] leftRow, int[] rightRow, int indexLeft, int indexRight, int offset, int length, int[] elementScore) {
            for (int i = 0; i < length; ++i) {
                int a = leftRow[indexLeft++];
                int b = rightRow[indexRight++];
                elementScore[offset + i] = DescriptorDistance.hamming((int)(a ^ b));
            }
        }

        @Override
        public ImageType<GrayS32> getImageType() {
            return ImageType.single(GrayS32.class);
        }
    }

    public static class U8
    extends CensusArrayS32_B32<GrayU8, byte[]> {
        public U8(int maxPerPixel) {
            super(maxPerPixel);
        }

        @Override
        public void score(byte[] leftRow, byte[] rightRow, int indexLeft, int indexRight, int offset, int length, int[] elementScore) {
            for (int i = 0; i < length; ++i) {
                int a = leftRow[indexLeft++] & 0xFF;
                int b = rightRow[indexRight++] & 0xFF;
                elementScore[offset + i] = DescriptorDistance.hamming((int)(a ^ b));
            }
        }

        @Override
        public ImageType<GrayU8> getImageType() {
            return ImageType.SB_U8;
        }
    }

    public static abstract class CensusArrayS32_B32<T extends GrayI<T>, ImageData>
    extends BlockRowScore.ArrayS32_BS32<T, ImageData> {
        CensusArrayS32_B32(int maxPerPixel) {
            super(maxPerPixel);
        }

        @Override
        public boolean isRequireNormalize() {
            return false;
        }
    }
}

