/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.PointToPixelTransform_F64;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.ops.ConvertMatrixData;

public class BundleToRectificationStereoParameters {
    public final CameraPinholeBrown intrinsic1 = new CameraPinholeBrown();
    public final CameraPinholeBrown intrinsic2 = new CameraPinholeBrown();
    public PixelTransform<Point2D_F64> view1_dist_to_undist;
    public final DMatrixRMaj K1 = new DMatrixRMaj(3, 3);
    public final DMatrixRMaj K2 = new DMatrixRMaj(3, 3);
    public final DMatrixRMaj rectifiedK = new DMatrixRMaj(3, 3);
    public final ImageDimension rectifiedShape = new ImageDimension();
    public final DMatrixRMaj undist_to_rect1 = new DMatrixRMaj(3, 3);
    public final DMatrixRMaj undist_to_rect2 = new DMatrixRMaj(3, 3);
    public final FMatrixRMaj undist_to_rect1_F32 = new FMatrixRMaj(3, 3);
    public final FMatrixRMaj undist_to_rect2_F32 = new FMatrixRMaj(3, 3);
    public final DMatrixRMaj rotate_orig_to_rect = new DMatrixRMaj(3, 3);
    final RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
    final Se3_F64 view1_to_view1 = new Se3_F64();

    public void setView1(BundleAdjustmentCamera bundle1, int width, int height) {
        BoofMiscOps.checkTrue((width > 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((height > 0 ? 1 : 0) != 0);
        BundleAdjustmentOps.convert((BundleAdjustmentCamera)bundle1, (int)width, (int)height, (CameraPinholeBrown)this.intrinsic1);
        PerspectiveOps.pinholeToMatrix((CameraPinhole)this.intrinsic1, (DMatrixRMaj)this.K1);
        this.intrinsic1.width = width;
        this.intrinsic1.height = height;
        Point2Transform2_F64 p_to_p = new LensDistortionBrown(this.intrinsic1).undistort_F64(true, true);
        this.view1_dist_to_undist = new PointToPixelTransform_F64(p_to_p);
    }

    public void processView2(BundleAdjustmentCamera bundle2, int width, int height, Se3_F64 view1_to_view2) {
        BoofMiscOps.checkTrue((this.intrinsic1.width != 0 ? 1 : 0) != 0, (String)"Did you call setView1() Must be called first.");
        BundleAdjustmentOps.convert((BundleAdjustmentCamera)bundle2, (int)width, (int)height, (CameraPinholeBrown)this.intrinsic2);
        PerspectiveOps.pinholeToMatrix((CameraPinhole)this.intrinsic2, (DMatrixRMaj)this.K2);
        this.rectifyAlg.process(this.K1, this.view1_to_view1, this.K2, view1_to_view2);
        this.undist_to_rect1.set((DMatrixD1)this.rectifyAlg.getUndistToRectPixels1());
        this.undist_to_rect2.set((DMatrixD1)this.rectifyAlg.getUndistToRectPixels2());
        this.rotate_orig_to_rect.set((DMatrixD1)this.rectifyAlg.getRectifiedRotation());
        BoofMiscOps.checkTrue((!MatrixFeatures_DDRM.hasUncountable((DMatrixD1)this.undist_to_rect1) ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((!MatrixFeatures_DDRM.hasUncountable((DMatrixD1)this.undist_to_rect2) ? 1 : 0) != 0);
        this.rectifiedK.set((DMatrixD1)this.rectifyAlg.getCalibrationMatrix());
        RectifyImageOps.fullViewLeft((CameraPinholeBrown)this.intrinsic1, (DMatrixRMaj)this.undist_to_rect1, (DMatrixRMaj)this.undist_to_rect2, (DMatrixRMaj)this.rectifiedK, (ImageDimension)this.rectifiedShape);
        ConvertMatrixData.convert((DMatrixRMaj)this.undist_to_rect1, (FMatrixRMaj)this.undist_to_rect1_F32);
        ConvertMatrixData.convert((DMatrixRMaj)this.undist_to_rect2, (FMatrixRMaj)this.undist_to_rect2_F32);
    }
}

