/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.misc.BoofLambdas;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;

public class ImplMultiViewStereoOps {
    public static void disparityToCloud(GrayF32 disparity, GrayU8 mask, DisparityParameters parameters, BoofLambdas.PixXyzConsumer_F64 consumer) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)mask);
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int indexMask = mask.startIndex + pixY * mask.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                float d;
                if (mask.data[indexMask] == 0 && !((d = disparity.data[indexDisp]) >= (float)parameters.disparityRange)) {
                    PerspectiveOps.convertPixelToNorm((CameraPinhole)intrinsic, (double)pixX, (double)pixY, (Point2D_F64)norm);
                    double Z = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X = Z * norm.x;
                    double Y = Z * norm.y;
                    double outX = R[0] * X + R[3] * Y + R[6] * Z;
                    double outY = R[1] * X + R[4] * Y + R[7] * Z;
                    double outZ = R[2] * X + R[5] * Y + R[8] * Z;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
                ++indexMask;
            }
        }
    }

    public static void disparityToCloud(GrayF32 disparity, DisparityParameters parameters, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                float d = disparity.data[indexDisp];
                if (!(d >= (float)parameters.disparityRange)) {
                    pixelToNorm.compute(pixX, pixY, (Object)norm);
                    double Z = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X = Z * norm.x;
                    double Y = Z * norm.y;
                    double outX = R[0] * X + R[3] * Y + R[6] * Z;
                    double outY = R[1] * X + R[4] * Y + R[7] * Z;
                    double outZ = R[2] * X + R[5] * Y + R[8] * Z;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }

    public static void disparityToCloud(GrayU8 disparity, DisparityParameters parameters, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                int d = disparity.data[indexDisp] & 0xFF;
                if (d < parameters.disparityRange) {
                    pixelToNorm.compute(pixX, pixY, (Object)norm);
                    double Z = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X = Z * norm.x;
                    double Y = Z * norm.y;
                    double outX = R[0] * X + R[3] * Y + R[6] * Z;
                    double outY = R[1] * X + R[4] * Y + R[7] * Z;
                    double outZ = R[2] * X + R[5] * Y + R[8] * Z;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }
}

