/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class FilterSequence<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements FilterImageInterface<Input, Output> {
    FilterImageInterface<Input, Output> firstFilter;
    FilterImageInterface<Output, Output>[] sequence;
    int borderHorizontal = 0;
    int borderVertical = 0;

    public FilterSequence(FilterImageInterface<Input, Output> first, FilterImageInterface<Output, Output> ... sequence) {
        this.firstFilter = first;
        this.sequence = sequence;
        if (first.getBorderX() > this.borderHorizontal) {
            this.borderHorizontal = first.getBorderX();
        }
        if (first.getBorderY() > this.borderVertical) {
            this.borderVertical = first.getBorderY();
        }
        for (FilterImageInterface<Output, Output> f : sequence) {
            if (f.getBorderX() > this.borderHorizontal) {
                this.borderHorizontal = f.getBorderX();
            }
            if (f.getBorderY() <= this.borderVertical) continue;
            this.borderVertical = f.getBorderY();
        }
    }

    @Override
    public void process(Input input, Output output) {
        ImageGray temp1 = (ImageGray)output.createNew(((ImageGray)output).width, ((ImageGray)output).height);
        ImageGray temp2 = (ImageGray)output.createNew(((ImageGray)output).width, ((ImageGray)output).height);
        this.firstFilter.process(input, temp1);
        for (FilterImageInterface<ImageGray, ImageGray> filterImageInterface : this.sequence) {
            filterImageInterface.process(temp1, temp2);
            ImageGray swap = temp1;
            temp1 = temp2;
            temp2 = swap;
            GImageMiscOps.fill((ImageBase)temp2, 0.0);
        }
        output.setTo(temp1);
    }

    @Override
    public int getBorderX() {
        return this.borderHorizontal;
    }

    @Override
    public int getBorderY() {
        return this.borderVertical;
    }

    @Override
    public ImageType<Input> getInputType() {
        return this.firstFilter.getInputType();
    }

    @Override
    public ImageType<Output> getOutputType() {
        return this.firstFilter.getOutputType();
    }
}

