/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayU8;

public class ImplEnhanceFilter {
    public static void sharpenInner4(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        for (int y = 1; y < input.height - 1; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                int a = 5 * (input.data[indexIn] & 0xFF) - ((input.data[indexIn - 1] & 0xFF) + (input.data[indexIn + 1] & 0xFF) + (input.data[indexIn - input.stride] & 0xFF) + (input.data[indexIn + input.stride] & 0xFF));
                if (a > maxValue) {
                    a = maxValue;
                } else if (a < minValue) {
                    a = minValue;
                }
                output.data[indexOut] = (byte)a;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void sharpenBorder4(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        int value;
        int b = input.height - 1;
        int c = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + b * input.stride + x;
            value = 4 * ImplEnhanceFilter.safeGet((GrayI)input, x, 0) - (ImplEnhanceFilter.safeGet((GrayI)input, x - 1, 0) + ImplEnhanceFilter.safeGet((GrayI)input, x + 1, 0) + ImplEnhanceFilter.safeGet((GrayI)input, x, 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = (byte)value;
            value = 4 * ImplEnhanceFilter.safeGet((GrayI)input, x, b) - (ImplEnhanceFilter.safeGet((GrayI)input, x - 1, b) + ImplEnhanceFilter.safeGet((GrayI)input, x + 1, b) + ImplEnhanceFilter.safeGet((GrayI)input, x, b - 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = (byte)value;
        }
        for (int y = 1; y < input.height - 1; ++y) {
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            value = 4 * ImplEnhanceFilter.safeGet((GrayI)input, 0, y) - (ImplEnhanceFilter.safeGet((GrayI)input, 1, y) + ImplEnhanceFilter.safeGet((GrayI)input, 0, y - 1) + ImplEnhanceFilter.safeGet((GrayI)input, 0, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = (byte)value;
            value = 4 * ImplEnhanceFilter.safeGet((GrayI)input, c, y) - (ImplEnhanceFilter.safeGet((GrayI)input, c - 1, y) + ImplEnhanceFilter.safeGet((GrayI)input, c, y - 1) + ImplEnhanceFilter.safeGet((GrayI)input, c, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = (byte)value;
        }
    }

    public static void sharpenInner4(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        for (int y = 1; y < input.height - 1; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                float a = 5.0f * input.data[indexIn] - (input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn - input.stride] + input.data[indexIn + input.stride]);
                if (a > maxValue) {
                    a = maxValue;
                } else if (a < minValue) {
                    a = minValue;
                }
                output.data[indexOut] = a;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void sharpenBorder4(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        float value;
        int b = input.height - 1;
        int c = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + b * input.stride + x;
            value = 4.0f * ImplEnhanceFilter.safeGet(input, x, 0) - (ImplEnhanceFilter.safeGet(input, x - 1, 0) + ImplEnhanceFilter.safeGet(input, x + 1, 0) + ImplEnhanceFilter.safeGet(input, x, 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = value;
            value = 4.0f * ImplEnhanceFilter.safeGet(input, x, b) - (ImplEnhanceFilter.safeGet(input, x - 1, b) + ImplEnhanceFilter.safeGet(input, x + 1, b) + ImplEnhanceFilter.safeGet(input, x, b - 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = value;
        }
        for (int y = 1; y < input.height - 1; ++y) {
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            value = 4.0f * ImplEnhanceFilter.safeGet(input, 0, y) - (ImplEnhanceFilter.safeGet(input, 1, y) + ImplEnhanceFilter.safeGet(input, 0, y - 1) + ImplEnhanceFilter.safeGet(input, 0, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = value;
            value = 4.0f * ImplEnhanceFilter.safeGet(input, c, y) - (ImplEnhanceFilter.safeGet(input, c - 1, y) + ImplEnhanceFilter.safeGet(input, c, y - 1) + ImplEnhanceFilter.safeGet(input, c, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = value;
        }
    }

    public static void sharpenInner8(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        for (int y = 1; y < input.height - 1; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                int a22 = input.data[indexIn] & 0xFF;
                int a11 = input.data[indexIn - input.stride - 1] & 0xFF;
                int a12 = input.data[indexIn - input.stride] & 0xFF;
                int a13 = input.data[indexIn - input.stride + 1] & 0xFF;
                int a21 = input.data[indexIn - 1] & 0xFF;
                int a23 = input.data[indexIn + 1] & 0xFF;
                int a31 = input.data[indexIn + input.stride - 1] & 0xFF;
                int a32 = input.data[indexIn + input.stride] & 0xFF;
                int a33 = input.data[indexIn + input.stride + 1] & 0xFF;
                int result = 9 * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
                if (result > maxValue) {
                    result = maxValue;
                } else if (result < minValue) {
                    result = minValue;
                }
                output.data[indexOut] = (byte)result;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void sharpenBorder8(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        int value;
        int a33;
        int a32;
        int a31;
        int a23;
        int a22;
        int a21;
        int a13;
        int a12;
        int a11;
        int b = input.height - 1;
        int c = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + x + b * input.stride;
            a11 = ImplEnhanceFilter.safeGet((GrayI)input, x - 1, -1);
            a12 = ImplEnhanceFilter.safeGet((GrayI)input, x, -1);
            a13 = ImplEnhanceFilter.safeGet((GrayI)input, x + 1, -1);
            a21 = ImplEnhanceFilter.safeGet((GrayI)input, x - 1, 0);
            a22 = ImplEnhanceFilter.safeGet((GrayI)input, x, 0);
            value = 9 * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter.safeGet((GrayI)input, x + 1, 0)) + (a31 = ImplEnhanceFilter.safeGet((GrayI)input, x - 1, 1)) + (a32 = ImplEnhanceFilter.safeGet((GrayI)input, x, 1)) + (a33 = ImplEnhanceFilter.safeGet((GrayI)input, x + 1, 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = (byte)value;
            a11 = ImplEnhanceFilter.safeGet((GrayI)input, x - 1, b - 1);
            a12 = ImplEnhanceFilter.safeGet((GrayI)input, x, b - 1);
            a13 = ImplEnhanceFilter.safeGet((GrayI)input, x + 1, b - 1);
            a21 = ImplEnhanceFilter.safeGet((GrayI)input, x - 1, b);
            a22 = ImplEnhanceFilter.safeGet((GrayI)input, x, b);
            a23 = ImplEnhanceFilter.safeGet((GrayI)input, x + 1, b);
            a31 = ImplEnhanceFilter.safeGet((GrayI)input, x - 1, b + 1);
            a32 = ImplEnhanceFilter.safeGet((GrayI)input, x, b + 1);
            a33 = ImplEnhanceFilter.safeGet((GrayI)input, x + 1, b + 1);
            value = 9 * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = (byte)value;
        }
        for (int y = 1; y < input.height - 1; ++y) {
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            a11 = ImplEnhanceFilter.safeGet((GrayI)input, -1, y - 1);
            a12 = ImplEnhanceFilter.safeGet((GrayI)input, 0, y - 1);
            a13 = ImplEnhanceFilter.safeGet((GrayI)input, 1, y - 1);
            a21 = ImplEnhanceFilter.safeGet((GrayI)input, -1, y);
            a22 = ImplEnhanceFilter.safeGet((GrayI)input, 0, y);
            value = 9 * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter.safeGet((GrayI)input, 1, y)) + (a31 = ImplEnhanceFilter.safeGet((GrayI)input, -1, y + 1)) + (a32 = ImplEnhanceFilter.safeGet((GrayI)input, 0, y + 1)) + (a33 = ImplEnhanceFilter.safeGet((GrayI)input, 1, y + 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = (byte)value;
            a11 = ImplEnhanceFilter.safeGet((GrayI)input, c - 1, y - 1);
            a12 = ImplEnhanceFilter.safeGet((GrayI)input, c, y - 1);
            a13 = ImplEnhanceFilter.safeGet((GrayI)input, c + 1, y - 1);
            a21 = ImplEnhanceFilter.safeGet((GrayI)input, c - 1, y);
            a22 = ImplEnhanceFilter.safeGet((GrayI)input, c, y);
            a23 = ImplEnhanceFilter.safeGet((GrayI)input, c + 1, y);
            a31 = ImplEnhanceFilter.safeGet((GrayI)input, c - 1, y + 1);
            a32 = ImplEnhanceFilter.safeGet((GrayI)input, c, y + 1);
            a33 = ImplEnhanceFilter.safeGet((GrayI)input, c + 1, y + 1);
            value = 9 * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = (byte)value;
        }
    }

    public static void sharpenInner8(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        for (int y = 1; y < input.height - 1; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                float a22 = input.data[indexIn];
                float a11 = input.data[indexIn - input.stride - 1];
                float a12 = input.data[indexIn - input.stride];
                float a13 = input.data[indexIn - input.stride + 1];
                float a21 = input.data[indexIn - 1];
                float a23 = input.data[indexIn + 1];
                float a31 = input.data[indexIn + input.stride - 1];
                float a32 = input.data[indexIn + input.stride];
                float a33 = input.data[indexIn + input.stride + 1];
                float result = 9.0f * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
                if (result > maxValue) {
                    result = maxValue;
                } else if (result < minValue) {
                    result = minValue;
                }
                output.data[indexOut] = result;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void sharpenBorder8(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        float value;
        float a33;
        float a32;
        float a31;
        float a23;
        float a22;
        float a21;
        float a13;
        float a12;
        float a11;
        int b = input.height - 1;
        int c = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + x + b * input.stride;
            a11 = ImplEnhanceFilter.safeGet(input, x - 1, -1);
            a12 = ImplEnhanceFilter.safeGet(input, x, -1);
            a13 = ImplEnhanceFilter.safeGet(input, x + 1, -1);
            a21 = ImplEnhanceFilter.safeGet(input, x - 1, 0);
            a22 = ImplEnhanceFilter.safeGet(input, x, 0);
            value = 9.0f * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter.safeGet(input, x + 1, 0)) + (a31 = ImplEnhanceFilter.safeGet(input, x - 1, 1)) + (a32 = ImplEnhanceFilter.safeGet(input, x, 1)) + (a33 = ImplEnhanceFilter.safeGet(input, x + 1, 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = value;
            a11 = ImplEnhanceFilter.safeGet(input, x - 1, b - 1);
            a12 = ImplEnhanceFilter.safeGet(input, x, b - 1);
            a13 = ImplEnhanceFilter.safeGet(input, x + 1, b - 1);
            a21 = ImplEnhanceFilter.safeGet(input, x - 1, b);
            a22 = ImplEnhanceFilter.safeGet(input, x, b);
            a23 = ImplEnhanceFilter.safeGet(input, x + 1, b);
            a31 = ImplEnhanceFilter.safeGet(input, x - 1, b + 1);
            a32 = ImplEnhanceFilter.safeGet(input, x, b + 1);
            a33 = ImplEnhanceFilter.safeGet(input, x + 1, b + 1);
            value = 9.0f * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = value;
        }
        for (int y = 1; y < input.height - 1; ++y) {
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            a11 = ImplEnhanceFilter.safeGet(input, -1, y - 1);
            a12 = ImplEnhanceFilter.safeGet(input, 0, y - 1);
            a13 = ImplEnhanceFilter.safeGet(input, 1, y - 1);
            a21 = ImplEnhanceFilter.safeGet(input, -1, y);
            a22 = ImplEnhanceFilter.safeGet(input, 0, y);
            value = 9.0f * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter.safeGet(input, 1, y)) + (a31 = ImplEnhanceFilter.safeGet(input, -1, y + 1)) + (a32 = ImplEnhanceFilter.safeGet(input, 0, y + 1)) + (a33 = ImplEnhanceFilter.safeGet(input, 1, y + 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = value;
            a11 = ImplEnhanceFilter.safeGet(input, c - 1, y - 1);
            a12 = ImplEnhanceFilter.safeGet(input, c, y - 1);
            a13 = ImplEnhanceFilter.safeGet(input, c + 1, y - 1);
            a21 = ImplEnhanceFilter.safeGet(input, c - 1, y);
            a22 = ImplEnhanceFilter.safeGet(input, c, y);
            a23 = ImplEnhanceFilter.safeGet(input, c + 1, y);
            a31 = ImplEnhanceFilter.safeGet(input, c - 1, y + 1);
            a32 = ImplEnhanceFilter.safeGet(input, c, y + 1);
            a33 = ImplEnhanceFilter.safeGet(input, c + 1, y + 1);
            value = 9.0f * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = value;
        }
    }

    public static int safeGet(GrayI input, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= input.width) {
            x = input.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= input.height) {
            y = input.height - 1;
        }
        return input.unsafe_get(x, y);
    }

    public static float safeGet(GrayF32 input, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= input.width) {
            x = input.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= input.height) {
            y = input.height - 1;
        }
        return input.unsafe_get(x, y);
    }
}

