/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.filter.binary.ContourPacked;
import boofcv.alg.filter.binary.ContourTracer;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.ConnectRule;
import boofcv.struct.PackedSetsPoint2D_I32;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import org.ddogleg.struct.DogArray;

public class LinearContourLabelChang2004 {
    private int minContourSize = 0;
    private int maxContourSize = Integer.MAX_VALUE;
    private boolean saveInternalContours = true;
    private ContourTracer tracer;
    private final GrayU8 border = new GrayU8(1, 1);
    PackedSetsPoint2D_I32 packedPoints = new PackedSetsPoint2D_I32(2000);
    private final DogArray<ContourPacked> contours = new DogArray(ContourPacked::new);
    private int x;
    private int y;
    private int indexIn;
    private int indexOut;

    public LinearContourLabelChang2004(ConnectRule rule) {
        this.tracer = new ContourTracer(rule);
    }

    public void process(GrayU8 binary, GrayS32 labeled) {
        labeled.reshape(binary.width, binary.height);
        if (this.border.width != binary.width + 2 || this.border.height != binary.height + 2) {
            this.border.reshape(binary.width + 2, binary.height + 2);
            ImageMiscOps.fillBorder((GrayI8)this.border, 0, 1);
        }
        ((GrayU8)this.border.subimage(1, 1, this.border.width - 1, this.border.height - 1, null)).setTo((ImageGray)binary);
        ImageMiscOps.fill(labeled, 0);
        binary = this.border;
        this.packedPoints.reset();
        this.contours.reset();
        this.tracer.setInputs(binary, labeled, this.packedPoints);
        int endY = binary.height - 1;
        int enxX = binary.width - 1;
        this.y = 1;
        while (this.y < endY) {
            this.indexIn = binary.startIndex + this.y * binary.stride + 1;
            this.indexOut = labeled.startIndex + (this.y - 1) * labeled.stride;
            this.x = 1;
            int delta = this.scanForOne(binary.data, this.indexIn, this.indexIn + enxX - this.x) - this.indexIn;
            this.x += delta;
            this.indexIn += delta;
            this.indexOut += delta;
            while (this.x < enxX) {
                int label = labeled.data[this.indexOut];
                boolean handled = false;
                if (label == 0 && binary.data[this.indexIn - binary.stride] != 1) {
                    this.handleStep1();
                    handled = true;
                    label = this.contours.size;
                }
                if (binary.data[this.indexIn + binary.stride] == 0) {
                    this.handleStep2(labeled, label);
                    handled = true;
                }
                if (!handled && labeled.data[this.indexOut] == 0) {
                    labeled.data[this.indexOut] = labeled.data[this.indexOut - 1];
                }
                delta = this.scanForOne(binary.data, this.indexIn + 1, this.indexIn + enxX - this.x) - this.indexIn;
                this.x += delta;
                this.indexIn += delta;
                this.indexOut += delta;
            }
            ++this.y;
        }
    }

    private int scanForOne(byte[] data, int index, int end) {
        while (index < end && data[index] != 1) {
            ++index;
        }
        return index;
    }

    public DogArray<ContourPacked> getContours() {
        return this.contours;
    }

    private void handleStep1() {
        ContourPacked c = (ContourPacked)this.contours.grow();
        c.reset();
        c.id = this.contours.size();
        this.tracer.setMaxContourSize(this.maxContourSize);
        c.externalIndex = this.packedPoints.size();
        this.packedPoints.grow();
        c.internalIndexes.reset();
        this.tracer.trace(this.contours.size(), this.x, this.y, true);
        if (this.packedPoints.sizeOfTail() >= this.maxContourSize || this.packedPoints.sizeOfTail() < this.minContourSize) {
            this.packedPoints.removeTail();
            this.packedPoints.grow();
        }
    }

    private void handleStep2(GrayS32 labeled, int label) {
        if (label == 0) {
            label = labeled.data[this.indexOut - 1];
        }
        ContourPacked c = (ContourPacked)this.contours.get(label - 1);
        c.internalIndexes.add(this.packedPoints.size());
        this.packedPoints.grow();
        this.tracer.setMaxContourSize(this.saveInternalContours ? this.maxContourSize : 0);
        this.tracer.trace(label, this.x, this.y, false);
        if (this.packedPoints.sizeOfTail() >= this.maxContourSize || this.packedPoints.sizeOfTail() < this.minContourSize) {
            this.packedPoints.removeTail();
            this.packedPoints.grow();
        }
    }

    public void setConnectRule(ConnectRule rule) {
        if (rule != this.tracer.getConnectRule()) {
            this.tracer = new ContourTracer(rule);
        }
    }

    public ConnectRule getConnectRule() {
        return this.tracer.getConnectRule();
    }

    public int getMinContourSize() {
        return this.minContourSize;
    }

    public void setMinContourSize(int minContourSize) {
        this.minContourSize = minContourSize;
    }

    public int getMaxContourSize() {
        return this.maxContourSize;
    }

    public void setMaxContourSize(int maxContourSize) {
        this.maxContourSize = maxContourSize;
    }

    public boolean isSaveInternalContours() {
        return this.saveInternalContours;
    }

    public void setSaveInternalContours(boolean saveInternalContours) {
        this.saveInternalContours = saveInternalContours;
    }

    public PackedSetsPoint2D_I32 getPackedPoints() {
        return this.packedPoints;
    }
}

