/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.misc.PixelMath;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray_F32;
import pabeles.concurrency.GrowArray;

public class ThresholdNick_MT
implements InputToBinary<GrayF32> {
    float k;
    ConfigLength width;
    boolean down;
    GrayF32 imageI2 = new GrayF32(1, 1);
    GrayF32 meanImage = new GrayF32(1, 1);
    GrayF32 meanI2 = new GrayF32(1, 1);
    GrayF32 tmp = new GrayF32(1, 1);
    GrowArray<DogArray_F32> work = new GrowArray(DogArray_F32::new);

    public ThresholdNick_MT(ConfigLength width, float k, boolean down) {
        this.k = k;
        this.width = width;
        this.down = down;
    }

    @Override
    public void process(GrayF32 input, GrayU8 output) {
        output.reshape(input.width, input.height);
        this.imageI2.reshape(input.width, input.height);
        this.meanImage.reshape(input.width, input.height);
        this.meanI2.reshape(input.width, input.height);
        this.tmp.reshape(input.width, input.height);
        this.imageI2.reshape(input.width, input.height);
        int radius = this.width.computeI((double)Math.min(input.width, input.height)) / 2;
        float NP = (radius * 2 + 1) * (radius * 2 + 1);
        BlurImageOps.mean(input, this.meanImage, radius, this.tmp, this.work);
        PixelMath.pow2(input, this.imageI2);
        BlurImageOps.mean(this.imageI2, this.meanI2, radius, this.tmp, this.work);
        if (this.down) {
            BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
                int i = y * this.meanI2.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float mean = this.meanImage.data[i];
                    float A = this.meanI2.data[i] - mean * mean / NP;
                    float threshold = mean + this.k * (float)Math.sqrt(A);
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            });
        } else {
            BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
                int i = y * this.meanI2.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float mean = this.meanImage.data[i];
                    float A = this.meanI2.data[i] - mean * mean / NP;
                    float threshold = mean + this.k * (float)Math.sqrt(A);
                    output.data[indexOut++] = (byte)(input.data[indexIn++] >= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            });
        }
    }

    @Override
    public ImageType<GrayF32> getInputType() {
        return ImageType.SB_F32;
    }

    public float getK() {
        return this.k;
    }

    public void setK(float k) {
        this.k = k;
    }

    public ConfigLength getWidth() {
        return this.width;
    }

    public void setWidth(ConfigLength width) {
        this.width = width;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }
}

