/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.struct.border.ImageBorderValue;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayU8;

public class ImplBinaryBorderOps {
    public static void erode4(GrayU8 input, GrayU8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap((GrayI)input, (int)0);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x, 1) == 4) {
                output.unsafe_set(x, 0, 1);
            } else {
                output.unsafe_set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x, h - 1) == 4) {
                output.unsafe_set(x, h, 1);
                continue;
            }
            output.unsafe_set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(0, y + 1) == 4) {
                output.unsafe_set(0, y, 1);
            } else {
                output.unsafe_set(0, y, 0);
            }
            if (in.get(w, y) + in.get(w - 1, y) + in.get(w, y - 1) + in.get(w, y + 1) == 4) {
                output.unsafe_set(w, y, 1);
                continue;
            }
            output.unsafe_set(w, y, 0);
        }
    }

    public static void dilate4(GrayU8 input, GrayU8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap((GrayI)input, (int)0);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x, 1) > 0) {
                output.unsafe_set(x, 0, 1);
            } else {
                output.unsafe_set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x, h - 1) > 0) {
                output.unsafe_set(x, h, 1);
                continue;
            }
            output.unsafe_set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(0, y + 1) > 0) {
                output.unsafe_set(0, y, 1);
            } else {
                output.unsafe_set(0, y, 0);
            }
            if (in.get(w, y) + in.get(w - 1, y) + in.get(w, y - 1) + in.get(w, y + 1) > 0) {
                output.unsafe_set(w, y, 1);
                continue;
            }
            output.unsafe_set(w, y, 0);
        }
    }

    public static void erode8(GrayU8 input, GrayU8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap((GrayI)input, (int)1);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1) == 6) {
                output.unsafe_set(x, 0, 1);
            } else {
                output.unsafe_set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1) == 6) {
                output.unsafe_set(x, h, 1);
                continue;
            }
            output.unsafe_set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1) == 6) {
                output.unsafe_set(0, y, 1);
            } else {
                output.unsafe_set(0, y, 0);
            }
            if (in.get(w - 1, y) + in.get(w, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1) == 6) {
                output.unsafe_set(w, y, 1);
                continue;
            }
            output.unsafe_set(w, y, 0);
        }
    }

    public static void dilate8(GrayU8 input, GrayU8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap((GrayI)input, (int)0);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x, 0) + in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1) > 0) {
                output.unsafe_set(x, 0, 1);
            } else {
                output.unsafe_set(x, 0, 0);
            }
            if (in.get(x, h) + in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1) > 0) {
                output.unsafe_set(x, h, 1);
                continue;
            }
            output.unsafe_set(x, h, 0);
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(0, y) + in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1) > 0) {
                output.unsafe_set(0, y, 1);
            } else {
                output.unsafe_set(0, y, 0);
            }
            if (in.get(w - 1, y) + in.get(w, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1) > 0) {
                output.unsafe_set(w, y, 1);
                continue;
            }
            output.unsafe_set(w, y, 0);
        }
    }

    private static void edge_outside0(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            output.unsafe_set(x, 0, input.get(x, 0));
            output.unsafe_set(x, h, input.get(x, h));
        }
        for (int y = 0; y < input.height; ++y) {
            output.unsafe_set(0, y, input.get(0, y));
            output.unsafe_set(w, y, input.get(w, y));
        }
    }

    public static void edge4(GrayU8 input, GrayU8 output, boolean outsideZero) {
        if (outsideZero) {
            ImplBinaryBorderOps.edge_outside0(input, output);
        } else {
            ImplBinaryBorderOps.edge4_outside1(input, output);
        }
    }

    private static void edge4_outside1(GrayU8 input, GrayU8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap((GrayI)input, (int)1);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x, 1) == 3) {
                output.unsafe_set(x, 0, 0);
            } else {
                output.unsafe_set(x, 0, input.get(x, 0));
            }
            if (in.get(x - 1, h) + in.get(x + 1, h) + in.get(x, h - 1) == 3) {
                output.unsafe_set(x, h, 0);
                continue;
            }
            output.unsafe_set(x, h, input.get(x, h));
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(1, y) + in.get(0, y - 1) + in.get(0, y + 1) == 3) {
                output.unsafe_set(0, y, 0);
            } else {
                output.unsafe_set(0, y, input.get(0, y));
            }
            if (in.get(w - 1, y) + in.get(w, y - 1) + in.get(w, y + 1) == 3) {
                output.unsafe_set(w, y, 0);
                continue;
            }
            output.unsafe_set(w, y, input.get(w, y));
        }
    }

    public static void edge8(GrayU8 input, GrayU8 output, boolean outsideZero) {
        if (outsideZero) {
            ImplBinaryBorderOps.edge_outside0(input, output);
        } else {
            ImplBinaryBorderOps.edge8_outside1(input, output);
        }
    }

    private static void edge8_outside1(GrayU8 input, GrayU8 output) {
        ImageBorder_S32 in = ImageBorderValue.wrap((GrayI)input, (int)1);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            if (in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1) == 5) {
                output.unsafe_set(x, 0, 0);
            } else {
                output.unsafe_set(x, 0, input.get(x, 0));
            }
            if (in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1) == 5) {
                output.unsafe_set(x, h, 0);
                continue;
            }
            output.unsafe_set(x, h, input.get(x, h));
        }
        for (int y = 0; y < input.height; ++y) {
            if (in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1) == 5) {
                output.unsafe_set(0, y, 0);
            } else {
                output.unsafe_set(0, y, input.get(0, y));
            }
            if (in.get(w - 1, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1) == 5) {
                output.unsafe_set(w, y, 0);
                continue;
            }
            output.unsafe_set(w, y, input.get(w, y));
        }
    }

    public static void removePointNoise(GrayU8 input, GrayU8 output) {
        int total;
        ImageBorder_S32 in = ImageBorderValue.wrap((GrayI)input, (int)0);
        int h = input.height - 1;
        int w = input.width - 1;
        for (int x = 0; x < input.width; ++x) {
            total = in.get(x - 1, 0) + in.get(x + 1, 0) + in.get(x - 1, 1) + in.get(x, 1) + in.get(x + 1, 1);
            if (total < 2) {
                output.unsafe_set(x, 0, 0);
            } else {
                output.unsafe_set(x, 0, input.get(x, 0));
            }
            total = in.get(x - 1, h) + in.get(x + 1, h) + in.get(x - 1, h - 1) + in.get(x, h - 1) + in.get(x + 1, h - 1);
            if (total < 2) {
                output.unsafe_set(x, h, 0);
                continue;
            }
            output.unsafe_set(x, h, input.get(x, h));
        }
        for (int y = 0; y < input.height; ++y) {
            total = in.get(1, y) + in.get(0, y - 1) + in.get(1, y - 1) + in.get(0, y + 1) + in.get(1, y + 1);
            if (total < 2) {
                output.unsafe_set(0, y, 0);
            } else {
                output.unsafe_set(0, y, input.get(0, y));
            }
            total = in.get(w - 1, y) + in.get(w - 1, y - 1) + in.get(w, y - 1) + in.get(w - 1, y + 1) + in.get(w, y + 1);
            if (total < 2) {
                output.unsafe_set(w, y, 0);
                continue;
            }
            output.unsafe_set(w, y, input.get(w, y));
        }
    }
}

