/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixelS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageType;

public class ImplBilinearPixel_S16
extends BilinearPixelS<GrayS16> {
    public ImplBilinearPixel_S16() {
    }

    public ImplBilinearPixel_S16(GrayS16 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((GrayS16)this.orig).startIndex + yt * this.stride + xt;
        short[] data = ((GrayS16)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * (float)data[index];
        val += ax * (1.0f - ay) * (float)data[index + 1];
        val += ax * ay * (float)data[index + 1 + this.stride];
        return val += (1.0f - ax) * ay * (float)data[index + this.stride];
    }

    public float get_border(float x, float y) {
        float xf = (float)Math.floor(x);
        float yf = (float)Math.floor(y);
        int xt = (int)xf;
        int yt = (int)yf;
        float ax = x - xf;
        float ay = y - yf;
        ImageBorder_S32 border = (ImageBorder_S32)this.border;
        float val = (1.0f - ax) * (1.0f - ay) * (float)border.get(xt, yt);
        val += ax * (1.0f - ay) * (float)border.get(xt + 1, yt);
        val += ax * ay * (float)border.get(xt + 1, yt + 1);
        return val += (1.0f - ax) * ay * (float)border.get(xt, yt + 1);
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 2) || y > (float)(this.height - 2)) {
            return this.get_border(x, y);
        }
        return this.get_fast(x, y);
    }

    @Override
    public InterpolatePixelS<GrayS16> copy() {
        ImplBilinearPixel_S16 out = new ImplBilinearPixel_S16();
        out.setBorder(this.border);
        return out;
    }

    @Override
    public ImageType<GrayS16> getImageType() {
        return ImageType.single(GrayS16.class);
    }
}

