/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.struct.ConfigGridUniform;
import boofcv.struct.ImageGrid;

public class ImageCoverage {
    public final ConfigGridUniform configUniform = new ConfigGridUniform(1.5, 1);
    public final ImageGrid<Cell> grid = new ImageGrid(Cell::new, Cell::reset);
    public double fraction;
    public int targetCellPixels;

    public void reset(int maxFeatures, int width, int height) {
        this.targetCellPixels = this.configUniform.selectTargetCellSize(maxFeatures, width, height);
        this.grid.initialize(this.targetCellPixels, width, height);
        this.fraction = 0.0;
    }

    public void markPixel(int pixelX, int pixelY) {
        ((Cell)this.grid.getCellAtPixel((int)pixelX, (int)pixelY)).covered = true;
    }

    public void process() {
        int total = 0;
        for (int i = 0; i < this.grid.cells.size; ++i) {
            if (!((Cell[])this.grid.cells.data)[i].covered) continue;
            ++total;
        }
        this.fraction = (double)total / (double)this.grid.cells.size;
    }

    public double getFraction() {
        return this.fraction;
    }

    protected static class Cell {
        boolean covered;

        protected Cell() {
        }

        public void reset() {
            this.covered = false;
        }
    }
}

