/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetectorPnP;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.fiducial.square.FoundFiducial;
import boofcv.alg.fiducial.square.QuadPoseEstimator;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class SquareBase_to_FiducialDetector<T extends ImageGray<T>, Detector extends BaseDetectFiducialSquare<T>>
extends FiducialDetectorPnP<T> {
    Detector alg;
    ImageType<T> type;
    private final LineGeneral2D_F64 line02 = new LineGeneral2D_F64();
    private final LineGeneral2D_F64 line13 = new LineGeneral2D_F64();
    QuadPoseEstimator poseEstimator = new QuadPoseEstimator(1.0E-6, 200);
    Quadrilateral_F64 quad = new Quadrilateral_F64();
    List<PointIndex2D_F64> listQuad = new ArrayList<PointIndex2D_F64>();
    List<Point2D3D> points2D3D;

    protected SquareBase_to_FiducialDetector(Detector alg) {
        this.alg = alg;
        this.type = ImageType.single(((BaseDetectFiducialSquare)alg).getInputType());
        this.poseEstimator.setFiducial(-0.5, 0.5, 0.5, 0.5, 0.5, -0.5, -0.5, -0.5);
        this.points2D3D = this.poseEstimator.createCopyPoints2D3D();
        for (int i = 0; i < 4; ++i) {
            this.listQuad.add(new PointIndex2D_F64());
            this.listQuad.get((int)i).index = i;
        }
    }

    @Override
    public void detect(T input) {
        ((BaseDetectFiducialSquare)this.alg).process(input);
    }

    @Override
    public void getCenter(int which, Point2D_F64 location) {
        Quadrilateral_F64 q = ((FoundFiducial)((BaseDetectFiducialSquare)this.alg).getFound().get((int)which)).distortedPixels;
        UtilLine2D_F64.convert((Point2D_F64)q.a, (Point2D_F64)q.c, (LineGeneral2D_F64)this.line02);
        UtilLine2D_F64.convert((Point2D_F64)q.b, (Point2D_F64)q.d, (LineGeneral2D_F64)this.line13);
        Intersection2D_F64.intersection((LineGeneral2D_F64)this.line02, (LineGeneral2D_F64)this.line13, (Point2D_F64)location);
    }

    @Override
    protected boolean estimatePose(int which, List<Point2D3D> points, Se3_F64 fiducialToCamera) {
        this.quad.a.setTo(points.get((int)0).observation);
        this.quad.b.setTo(points.get((int)1).observation);
        this.quad.c.setTo(points.get((int)2).observation);
        this.quad.d.setTo(points.get((int)3).observation);
        if (!this.poseEstimator.process(this.quad, false)) {
            return false;
        }
        fiducialToCamera.setTo(this.poseEstimator.getWorldToCamera());
        double width = this.getWidth(which);
        fiducialToCamera.T.x *= width;
        fiducialToCamera.T.y *= width;
        fiducialToCamera.T.z *= width;
        return true;
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        super.setLensDistortion(distortion, width, height);
        ((BaseDetectFiducialSquare)this.alg).configure(distortion, width, height, true);
        if (distortion != null) {
            this.poseEstimator.setLensDistoriton(distortion);
        }
    }

    @Override
    public int totalFound() {
        return ((BaseDetectFiducialSquare)this.alg).getFound().size;
    }

    @Override
    public long getId(int which) {
        return ((FoundFiducial)((BaseDetectFiducialSquare)this.alg).getFound().get((int)which)).id;
    }

    @Override
    public String getMessage(int which) {
        return null;
    }

    @Override
    public boolean hasID() {
        return true;
    }

    @Override
    public boolean hasMessage() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    public Detector getAlgorithm() {
        return this.alg;
    }

    @Override
    public List<PointIndex2D_F64> getDetectedControl(int which) {
        FoundFiducial found = (FoundFiducial)((BaseDetectFiducialSquare)this.getAlgorithm()).getFound().get(which);
        ((Point2D_F64)this.listQuad.get((int)0).p).setTo(found.distortedPixels.a);
        ((Point2D_F64)this.listQuad.get((int)1).p).setTo(found.distortedPixels.b);
        ((Point2D_F64)this.listQuad.get((int)2).p).setTo(found.distortedPixels.c);
        ((Point2D_F64)this.listQuad.get((int)3).p).setTo(found.distortedPixels.d);
        return this.listQuad;
    }

    @Override
    protected List<Point2D3D> getControl3D(int which) {
        return this.points2D3D;
    }

    @Override
    public Polygon2D_F64 getBounds(int which, @Nullable Polygon2D_F64 storage) {
        if (storage == null) {
            storage = new Polygon2D_F64();
        } else {
            storage.vertexes.reset();
        }
        FoundFiducial found = (FoundFiducial)((BaseDetectFiducialSquare)this.getAlgorithm()).getFound().get(which);
        ((Point2D_F64)storage.vertexes.grow()).setTo(found.distortedPixels.a);
        ((Point2D_F64)storage.vertexes.grow()).setTo(found.distortedPixels.b);
        ((Point2D_F64)storage.vertexes.grow()).setTo(found.distortedPixels.c);
        ((Point2D_F64)storage.vertexes.grow()).setTo(found.distortedPixels.d);
        return storage;
    }
}

