/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.tracker.circulant.CirculantTracker;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.RectangleLength2D_F32;

public class Circulant_to_TrackerObjectQuad<T extends ImageGray<T>>
implements TrackerObjectQuad<T> {
    CirculantTracker<T> tracker;
    Rectangle2D_F64 rect = new Rectangle2D_F64();
    ImageType<T> imageType;

    public Circulant_to_TrackerObjectQuad(CirculantTracker<T> tracker, ImageType<T> imageType) {
        this.tracker = tracker;
        this.imageType = imageType;
    }

    @Override
    public boolean initialize(T image, Quadrilateral_F64 location) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)location, (Rectangle2D_F64)this.rect);
        int width = (int)(this.rect.p1.x - this.rect.p0.x);
        int height = (int)(this.rect.p1.y - this.rect.p0.y);
        this.tracker.initialize(image, (int)this.rect.p0.x, (int)this.rect.p0.y, width, height);
        return true;
    }

    @Override
    public void hint(Quadrilateral_F64 hint) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)hint, (Rectangle2D_F64)this.rect);
        int width = (int)(this.rect.p1.x - this.rect.p0.x);
        int height = (int)(this.rect.p1.y - this.rect.p0.y);
        this.tracker.setTrackLocation((int)this.rect.p0.x, (int)this.rect.p0.y, width, height);
    }

    @Override
    public boolean process(T image, Quadrilateral_F64 results) {
        this.tracker.performTracking(image);
        RectangleLength2D_F32 r = this.tracker.getTargetLocation();
        if (r.x0 >= (float)((ImageGray)image).width || r.y0 >= (float)((ImageGray)image).height) {
            return false;
        }
        if (r.x0 + r.width < 0.0f || r.y0 + r.height < 0.0f) {
            return false;
        }
        float x0 = r.x0;
        float y0 = r.y0;
        float x1 = r.x0 + r.width;
        float y1 = r.y0 + r.height;
        results.a.x = x0;
        results.a.y = y0;
        results.b.x = x1;
        results.b.y = y0;
        results.c.x = x1;
        results.c.y = y1;
        results.d.x = x0;
        results.d.y = y1;
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public CirculantTracker<T> getLowLevelTracker() {
        return this.tracker;
    }
}

