/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.dots;

import boofcv.alg.drawing.FiducialRenderEngine;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.RectangleLength2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.DogArray;

public class RandomDotMarkerGenerator {
    protected FiducialRenderEngine render;
    double radius;
    protected final RectangleLength2D_F64 documentRegion = new RectangleLength2D_F64();
    DogArray<Point2D_F64> dotsAdjusted = new DogArray(Point2D_F64::new);

    public static List<Point2D_F64> createRandomMarker(Random rand, int num, double markerWidth, double markerHeight, double dotDiameter) {
        ArrayList<Point2D_F64> points = new ArrayList<Point2D_F64>();
        Point2D_F64 work = new Point2D_F64();
        double borderCushion = dotDiameter * 0.6;
        double effectiveWidth = markerWidth - 2.0 * borderCushion;
        double effectiveHeight = markerHeight - 2.0 * borderCushion;
        if (effectiveWidth <= 0.0 || effectiveHeight <= 0.0) {
            throw new IllegalArgumentException("Marker isn't wide enough for dots to not touch border");
        }
        double tol = 2.0 * dotDiameter * dotDiameter;
        int failedAttempts = 0;
        while (failedAttempts < 1000 && points.size() < num) {
            work.x = (rand.nextDouble() - 0.5) * effectiveWidth;
            work.y = (rand.nextDouble() - 0.5) * effectiveHeight;
            boolean good = true;
            for (int i = 0; i < points.size(); ++i) {
                if (!(points.get(i).distance2((GeoTuple2D_F64)work) < tol)) continue;
                good = false;
                break;
            }
            if (good) {
                points.add(work.copy());
                continue;
            }
            ++failedAttempts;
        }
        return points;
    }

    public void render(List<Point2D_F64> dots, double markerWidth, double markerHeight) {
        double regionCenterX = this.documentRegion.width / 2.0;
        double regionCenterY = this.documentRegion.height / 2.0;
        double point_to_pixel = Math.min(this.documentRegion.width / markerWidth, this.documentRegion.height / markerHeight);
        this.render.init();
        this.dotsAdjusted.reset();
        for (int dotIdx = 0; dotIdx < dots.size(); ++dotIdx) {
            Point2D_F64 p = dots.get(dotIdx);
            Point2D_F64 a = (Point2D_F64)this.dotsAdjusted.grow();
            a.x = p.x * point_to_pixel + regionCenterX;
            a.y = p.y * point_to_pixel + regionCenterY;
            this.render.circle(a.x, a.y, this.radius);
            this.render.inputToDocument(a.x, a.y, a);
        }
    }

    public FiducialRenderEngine getRender() {
        return this.render;
    }

    public void setRender(FiducialRenderEngine render) {
        this.render = render;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public RectangleLength2D_F64 getDocumentRegion() {
        return this.documentRegion;
    }

    public DogArray<Point2D_F64> getDotsAdjusted() {
        return this.dotsAdjusted;
    }
}

