/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.calib.squares.SquareGraph;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import boofcv.alg.interpolate.InterpolatePixelDistortS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.MovingAverage;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilLine2D_F64;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class QrCodePositionPatternDetector<T extends ImageGray<T>> {
    InterpolatePixelS<T> interpolate;
    int maxVersionQR;
    DetectPolygonBinaryGrayRefine<T> squareDetector;
    DogArray<PositionPatternNode> positionPatterns = new DogArray(PositionPatternNode::new);
    SquareGraph graph = new SquareGraph();
    private NearestNeighbor<SquareNode> nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new SquareNode.KdTreeSquareNode());
    private NearestNeighbor.Search<SquareNode> search = this.nn.createSearch();
    private DogArray<NnData<SquareNode>> searchResults = new DogArray(NnData::new);
    protected LineSegment2D_F64 lineA = new LineSegment2D_F64();
    protected LineSegment2D_F64 lineB = new LineSegment2D_F64();
    protected LineSegment2D_F64 connectLine = new LineSegment2D_F64();
    protected Point2D_F64 intersection = new Point2D_F64();
    protected MovingAverage milliGraph = new MovingAverage(0.8);
    protected boolean profiler = false;
    LineSegment2D_F64 segment = new LineSegment2D_F64();
    LineParametric2D_F64 parametric = new LineParametric2D_F64();
    float[] samples = new float[46];
    int[] length = new int[12];
    int[] type = new int[12];

    public QrCodePositionPatternDetector(DetectPolygonBinaryGrayRefine<T> squareDetector, int maxVersionQR) {
        this.squareDetector = squareDetector;
        this.maxVersionQR = maxVersionQR;
        squareDetector.getDetector().setConvex(true);
        squareDetector.getDetector().setOutputClockwise(false);
        squareDetector.getDetector().setNumberOfSides(4, 4);
        this.interpolate = FactoryInterpolation.bilinearPixelS((Class)squareDetector.getInputType(), (BorderType)BorderType.EXTENDED);
    }

    public void resetRuntimeProfiling() {
        this.squareDetector.resetRuntimeProfiling();
        this.milliGraph.reset();
    }

    public void setProfilerState(boolean active) {
        this.profiler = active;
    }

    public void process(T gray, GrayU8 binary) {
        this.configureContourDetector(gray);
        this.recycleData();
        this.positionPatterns.reset();
        this.interpolate.setImage(gray);
        this.squareDetector.process(gray, binary);
        long time0 = System.nanoTime();
        this.squaresToPositionList();
        long time1 = System.nanoTime();
        this.createPositionPatternGraph();
        double milli = (double)(time1 - time0) * 1.0E-6;
        this.milliGraph.update(milli);
        if (this.profiler) {
            DetectPolygonFromContour detectorPoly = this.squareDetector.getDetector();
            System.out.printf(" contour %5.1f shapes %5.1f adjust_bias %5.2f PosPat %6.2f", detectorPoly.getMilliContour(), detectorPoly.getMilliShapes(), this.squareDetector.getMilliAdjustBias(), this.milliGraph.getAverage());
        }
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.interpolate = FactoryInterpolation.bilinearPixelS((Class)this.squareDetector.getInputType(), (BorderType)BorderType.EXTENDED);
        if (model != null) {
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(model.undistort_F32(true, true));
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(model.distort_F32(true, true));
            this.squareDetector.setLensDistortion(width, height, (PixelTransform)distToUndist, (PixelTransform)undistToDist);
            Point2Transform2_F32 u2d = model.distort_F32(true, true);
            this.interpolate = new InterpolatePixelDistortS(this.interpolate, u2d);
        } else {
            this.squareDetector.setLensDistortion(width, height, null, null);
        }
    }

    private void configureContourDetector(T gray) {
        int maxContourSize = Math.min(((ImageGray)gray).width, ((ImageGray)gray).height) * 4 / 3;
        BinaryContourFinder contourFinder = this.squareDetector.getDetector().getContourFinder();
        contourFinder.setMaxContour(maxContourSize);
        contourFinder.setSaveInnerContour(false);
    }

    protected void recycleData() {
        for (int i = 0; i < this.positionPatterns.size(); ++i) {
            SquareNode n = (SquareNode)this.positionPatterns.get(i);
            for (int j = 0; j < n.edges.length; ++j) {
                if (n.edges[j] == null) continue;
                this.graph.detachEdge(n.edges[j]);
            }
        }
        this.positionPatterns.reset();
    }

    private void squaresToPositionList() {
        this.positionPatterns.reset();
        List infoList = this.squareDetector.getPolygonInfo();
        for (int i = 0; i < infoList.size(); ++i) {
            DetectPolygonFromContour.Info info = (DetectPolygonFromContour.Info)infoList.get(i);
            double grayThreshold = (info.edgeInside + info.edgeOutside) / 2.0;
            if (!this.checkPositionPatternAppearance(info.polygon, (float)grayThreshold)) continue;
            this.squareDetector.refine(info);
            PositionPatternNode pp = (PositionPatternNode)this.positionPatterns.grow();
            pp.reset();
            pp.square = info.polygon;
            pp.grayThreshold = grayThreshold;
            this.graph.computeNodeInfo(pp);
        }
    }

    private void createPositionPatternGraph() {
        this.nn.setPoints(this.positionPatterns.toList(), false);
        for (int i = 0; i < this.positionPatterns.size(); ++i) {
            PositionPatternNode f = (PositionPatternNode)this.positionPatterns.get(i);
            double maximumQrCodeWidth = f.largestSide * ((double)(17 + 4 * this.maxVersionQR) - 7.0) / 7.0;
            double searchRadius = 1.2 * maximumQrCodeWidth;
            searchRadius *= searchRadius;
            this.search.findNearest((Object)f, searchRadius, Integer.MAX_VALUE, this.searchResults);
            if (this.searchResults.size <= 1) continue;
            for (int j = 0; j < this.searchResults.size; ++j) {
                NnData r = (NnData)this.searchResults.get(j);
                if (r.point == f) continue;
                this.considerConnect(f, (SquareNode)r.point);
            }
        }
    }

    void considerConnect(SquareNode node0, SquareNode node1) {
        this.lineA.a = node0.center;
        this.lineA.b = node1.center;
        int intersection0 = this.graph.findSideIntersect(node0, this.lineA, this.intersection, this.lineB);
        this.connectLine.a.setTo(this.intersection);
        int intersection1 = this.graph.findSideIntersect(node1, this.lineA, this.intersection, this.lineB);
        this.connectLine.b.setTo(this.intersection);
        if (intersection1 < 0 || intersection0 < 0) {
            return;
        }
        double side0 = node0.sideLengths[intersection0];
        double side1 = node1.sideLengths[intersection1];
        double sideLoc0 = this.connectLine.a.distance((GeoTuple2D_F64)node0.square.get(intersection0)) / side0;
        double sideLoc1 = this.connectLine.b.distance((GeoTuple2D_F64)node1.square.get(intersection1)) / side1;
        if (Math.abs(sideLoc0 - 0.5) > 0.35 || Math.abs(sideLoc1 - 0.5) > 0.35) {
            return;
        }
        if (Math.abs(side0 - side1) / Math.max(side0, side1) > 0.25) {
            return;
        }
        if (!this.graph.almostParallel(node0, intersection0, node1, intersection1)) {
            return;
        }
        double ratio = Math.max(node0.smallestSide / node1.largestSide, node1.smallestSide / node0.largestSide);
        if (ratio > 1.3) {
            return;
        }
        double angle = this.graph.acuteAngle(node0, intersection0, node1, intersection1);
        double score = this.lineA.getLength() * (1.0 + angle / 0.1);
        this.graph.checkConnect(node0, intersection0, node1, intersection1, score);
    }

    boolean checkPositionPatternAppearance(Polygon2D_F64 square, float grayThreshold) {
        return this.checkLine(square, grayThreshold, 0) || this.checkLine(square, grayThreshold, 1);
    }

    private boolean checkLine(Polygon2D_F64 square, float grayThreshold, int side) {
        int i;
        int c0 = side;
        int c1 = (side + 1) % 4;
        int c2 = (side + 2) % 4;
        int c3 = (side + 3) % 4;
        UtilPoint2D_F64.mean((Point2D_F64)square.get(c0), (Point2D_F64)square.get(c1), (Point2D_F64)this.segment.a);
        UtilPoint2D_F64.mean((Point2D_F64)square.get(c2), (Point2D_F64)square.get(c3), (Point2D_F64)this.segment.b);
        UtilLine2D_F64.convert((LineSegment2D_F64)this.segment, (LineParametric2D_F64)this.parametric);
        int period = this.samples.length / 9;
        double N = this.samples.length - 2 * period - 1;
        for (int i2 = 0; i2 < this.samples.length; ++i2) {
            double location = (double)(i2 - period) / N;
            float x = (float)(this.parametric.p.x + location * this.parametric.slope.x);
            float y = (float)(this.parametric.p.y + location * this.parametric.slope.y);
            this.samples[i2] = this.interpolate.get(x, y);
        }
        int size = 0;
        boolean black = this.samples[0] < grayThreshold;
        this.type[0] = black ? 0 : 1;
        for (i = 0; i < this.samples.length; ++i) {
            boolean b;
            boolean bl = b = this.samples[i] < grayThreshold;
            if (black == b) {
                int n = size;
                this.length[n] = this.length[n] + 1;
                continue;
            }
            black = b;
            if (size >= this.type.length - 1) break;
            this.type[++size] = black ? 0 : 1;
            this.length[size] = 1;
        }
        if (++size < 5 || size > 9) {
            return false;
        }
        i = 0;
        while (i + 5 <= size) {
            if (this.type[i] == 0) {
                int black02;
                int black0 = this.length[i];
                int black1 = this.length[i + 2];
                int black2 = this.length[i + 4];
                int white0 = this.length[i + 1];
                int white1 = this.length[i + 3];
                if (!((double)black0 < 0.4 * (double)white0) && black0 <= 3 * white0 && !((double)black2 < 0.4 * (double)white1) && black2 <= 3 * white1 && black1 >= (black02 = black0 + black2) && black1 <= 2 * black02) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    static boolean positionSquareIntensityCheck(float[] values, float threshold) {
        if (values[0] > threshold || values[1] < threshold) {
            return false;
        }
        if (values[2] > threshold || values[3] > threshold || values[4] > threshold) {
            return false;
        }
        return !(values[5] < threshold) && !(values[6] > threshold);
    }

    public DogArray<PositionPatternNode> getPositionPatterns() {
        return this.positionPatterns;
    }

    public DetectPolygonBinaryGrayRefine<T> getSquareDetector() {
        return this.squareDetector;
    }

    public SquareGraph getGraph() {
        return this.graph;
    }
}

