/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.struct.ImageRectangle;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.Rectangle2D_I32;

public class TldHelperFunctions {
    private ImageRectangle work = new ImageRectangle();

    public double computeOverlap(ImageRectangle a, ImageRectangle b) {
        if (!a.intersection(b, this.work)) {
            return 0.0;
        }
        int areaI = this.work.area();
        int bottom = a.area() + b.area() - areaI;
        return (double)areaI / (double)bottom;
    }

    public static void convertRegion(Rectangle2D_F64 input, Rectangle2D_I32 output) {
        output.x0 = (int)(input.p0.x + 0.5);
        output.x1 = (int)(input.p1.x + 0.5);
        output.y0 = (int)(input.p0.y + 0.5);
        output.y1 = (int)(input.p1.y + 0.5);
    }

    public static void convertRegion(Rectangle2D_I32 input, Rectangle2D_F64 output) {
        output.p0.setTo((double)input.x0, (double)input.y0);
        output.p1.setTo((double)input.x1, (double)input.y1);
    }
}

