/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.alg.feature.associate.StereoConsistencyCheck;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import boofcv.struct.feature.TupleDesc;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;

public class AssociateStereo2D<Desc extends TupleDesc>
extends StereoConsistencyCheck
implements AssociateDescription2D<Desc> {
    private final ScoreAssociation<Desc> scorer;
    private final DogArray<AssociatedIndex> matches = new DogArray(AssociatedIndex::new);
    private final DogArray_I32 unassociatedSrc = new DogArray_I32();
    private final FindUnassociated unassociated = new FindUnassociated();
    private double scoreThreshold = Double.MAX_VALUE;
    private final DogArray<Point2D_F64> locationLeft = new DogArray(Point2D_F64::new);
    private final DogArray<Point2D_F64> locationRight = new DogArray(Point2D_F64::new);
    private FastAccess<Desc> descriptionsLeft;
    private FastAccess<Desc> descriptionsRight;

    public AssociateStereo2D(ScoreAssociation<Desc> scorer, double locationTolerance, Class<Desc> descType) {
        super(locationTolerance, locationTolerance);
        this.scorer = scorer;
    }

    public void initialize(int imageWidth, int imageHeight) {
    }

    public void setSource(FastAccess<Point2D_F64> location, FastAccess<Desc> descriptions) {
        this.locationLeft.reset();
        for (int i = 0; i < location.size; ++i) {
            Point2D_F64 orig = (Point2D_F64)location.get(i);
            Point2D_F64 rectified = (Point2D_F64)this.locationLeft.grow();
            this.leftImageToRect.compute(orig.x, orig.y, rectified);
        }
        this.descriptionsLeft = descriptions;
    }

    public void setDestination(FastAccess<Point2D_F64> location, FastAccess<Desc> descriptions) {
        this.locationRight.reset();
        for (int i = 0; i < location.size; ++i) {
            Point2D_F64 orig = (Point2D_F64)location.get(i);
            Point2D_F64 rectified = (Point2D_F64)this.locationRight.grow();
            this.rightImageToRect.compute(orig.x, orig.y, rectified);
        }
        this.descriptionsRight = descriptions;
    }

    public void associate() {
        this.matches.reset();
        this.unassociatedSrc.reset();
        for (int i = 0; i < this.locationLeft.size; ++i) {
            Point2D_F64 left = (Point2D_F64)this.locationLeft.get(i);
            TupleDesc descLeft = (TupleDesc)this.descriptionsLeft.get(i);
            int bestIndex = -1;
            double bestScore = this.scoreThreshold;
            for (int j = 0; j < this.locationRight.size; ++j) {
                double dist;
                Point2D_F64 right = (Point2D_F64)this.locationRight.get(j);
                if (!this.checkRectified(left, right) || !((dist = this.scorer.score((Object)descLeft, (Object)((TupleDesc)this.descriptionsRight.get(j)))) < bestScore)) continue;
                bestScore = dist;
                bestIndex = j;
            }
            if (bestIndex >= 0) {
                ((AssociatedIndex)this.matches.grow()).setTo(i, bestIndex, bestScore);
                continue;
            }
            this.unassociatedSrc.push(i);
        }
    }

    public DogArray<AssociatedIndex> getMatches() {
        return this.matches;
    }

    public DogArray_I32 getUnassociatedSource() {
        return this.unassociatedSrc;
    }

    public DogArray_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.matches, this.locationRight.size);
    }

    public void setMaxScoreThreshold(double score) {
        this.scoreThreshold = score < 0.0 ? Double.MAX_VALUE : score;
    }

    public MatchScoreType getScoreType() {
        return this.scorer.getScoreType();
    }

    public boolean uniqueSource() {
        return true;
    }

    public boolean uniqueDestination() {
        return false;
    }
}

