/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.pose.CompatibleProjectiveHomography;
import boofcv.alg.sfm.structure.ExpandByOneView;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ProjectiveExpandByOneView
extends ExpandByOneView {
    CompatibleProjectiveHomography findCompatible = new CompatibleProjectiveHomography();
    List<PairwiseImageGraph.Motion> connections = new ArrayList<PairwiseImageGraph.Motion>();
    DMatrixRMaj localToGlobal = new DMatrixRMaj(4, 4);
    DMatrixRMaj globalToLocal = new DMatrixRMaj(4, 4);
    List<DMatrixRMaj> camerasLocal = new ArrayList<DMatrixRMaj>();
    List<DMatrixRMaj> camerasGlobal = new ArrayList<DMatrixRMaj>();

    public boolean process(LookUpSimilarImages db, SceneWorkingGraph workGraph, PairwiseImageGraph.View target, DMatrixRMaj cameraMatrix) {
        this.workGraph = workGraph;
        this.utils.db = db;
        if (!this.selectTwoConnections(target, this.connections)) {
            if (this.verbose != null) {
                this.verbose.println("Failed to expand because two connections couldn't be found. valid.size=" + this.validCandidates.size());
                for (int i = 0; i < this.validCandidates.size(); ++i) {
                    this.verbose.println("   valid view.id='" + ((PairwiseImageGraph.Motion)this.validCandidates.get((int)i)).other((PairwiseImageGraph.View)target).id + "'");
                }
            }
            return false;
        }
        this.utils.seed = target;
        this.utils.viewB = this.connections.get(0).other(target);
        this.utils.viewC = this.connections.get(1).other(target);
        this.utils.createThreeViewLookUpTables();
        this.utils.findCommonFeatures();
        if (this.verbose != null) {
            this.verbose.println("Expanding to view='" + target.id + "' using views ( '" + this.utils.viewB.id + "' , '" + this.utils.viewC.id + "') common=" + this.utils.commonIdx.size + " valid.size=" + this.validCandidates.size());
        }
        this.utils.createTripleFromCommon();
        if (!this.utils.estimateProjectiveCamerasRobustly()) {
            return false;
        }
        if (!this.computeConversionHomography()) {
            return false;
        }
        CommonOps_DDRM.invert((DMatrixRMaj)this.localToGlobal, (DMatrixRMaj)this.globalToLocal);
        CommonOps_DDRM.mult((DMatrix1Row)workGraph.lookupView((String)this.utils.viewB.id).projective, (DMatrix1Row)this.globalToLocal, (DMatrix1Row)this.utils.P2);
        CommonOps_DDRM.mult((DMatrix1Row)workGraph.lookupView((String)this.utils.viewC.id).projective, (DMatrix1Row)this.globalToLocal, (DMatrix1Row)this.utils.P3);
        this.utils.initializeSbaSceneThreeView(false);
        this.utils.initializeSbaObservationsThreeView();
        this.utils.refineWithBundleAdjustment();
        CommonOps_DDRM.mult((DMatrix1Row)((SceneStructureProjective.View)this.utils.structure.getViews().get((int)0)).worldToView, (DMatrix1Row)this.localToGlobal, (DMatrix1Row)cameraMatrix);
        return true;
    }

    boolean computeConversionHomography() {
        this.camerasLocal.clear();
        this.camerasGlobal.clear();
        this.camerasLocal.add(this.utils.P2);
        this.camerasLocal.add(this.utils.P3);
        this.camerasGlobal.add(this.workGraph.lookupView((String)this.utils.viewB.id).projective);
        this.camerasGlobal.add(this.workGraph.lookupView((String)this.utils.viewC.id).projective);
        return this.findCompatible.fitCameras(this.camerasLocal, this.camerasGlobal, this.localToGlobal);
    }
}

