/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.sfm.structure.ConfigProjectiveReconstruction;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.PairwiseGraphUtils;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.AssociatedTupleDN;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class ProjectiveInitializeAllCommon
implements VerbosePrint {
    PairwiseGraphUtils utils = new PairwiseGraphUtils(new ConfigProjectiveReconstruction());
    protected final DogArray_I32 inlierToSeed = new DogArray_I32();
    protected final DogArray<DogArray_I32> inlierIndexes = new DogArray(DogArray_I32::new, DogArray_I32::reset);
    protected final FastArray<PairwiseImageGraph.View> viewsByStructureIndex = new FastArray(PairwiseImageGraph.View.class);
    private PrintStream verbose;
    protected final int[] selectedTriple = new int[2];
    protected final DogArray<Point4D_F64> points3D = new DogArray(Point4D_F64::new);
    protected final DogArray<AssociatedPair> assocPixel = new DogArray(AssociatedPair::new);
    protected final ImageDimension shape = new ImageDimension();
    protected final DogArray_I32 seedToStructure = new DogArray_I32();

    public boolean projectiveSceneN(LookUpSimilarImages db, PairwiseImageGraph.View seed, DogArray_I32 seedFeatsIdx, DogArray_I32 seedConnIdx) {
        BoofMiscOps.checkTrue((seedFeatsIdx.size >= 6 ? 1 : 0) != 0, (String)"need at least 6 common features to estimate camera matrix");
        BoofMiscOps.checkTrue((seedConnIdx.size >= 2 ? 1 : 0) != 0, (String)"2-views, a.k.a. stereo, is a special case and requires different logic and isn't yet supported");
        BoofMiscOps.checkTrue((seed.connections.size >= seedConnIdx.size ? 1 : 0) != 0, (String)"Can't have more seed connection indexes than actual connections");
        if (this.verbose != null) {
            this.verbose.println("ENTER projectiveSceneN: seed=" + seed.id + " common.size=" + seedFeatsIdx.size + " conn.size=" + seedConnIdx.size);
        }
        this.utils.db = db;
        this.viewsByStructureIndex.reset();
        if (!this.selectInitialTriplet(seed, seedConnIdx, this.selectedTriple)) {
            if (this.verbose != null) {
                this.verbose.println("failed to select initial triplet");
            }
            return false;
        }
        this.utils.seed = seed;
        this.utils.viewB = ((PairwiseImageGraph.Motion)this.utils.seed.connections.get(this.selectedTriple[0])).other(seed);
        this.utils.viewC = ((PairwiseImageGraph.Motion)this.utils.seed.connections.get(this.selectedTriple[1])).other(seed);
        this.utils.createThreeViewLookUpTables();
        this.utils.findCommonFeatures(seedFeatsIdx);
        if (this.verbose != null) {
            this.verbose.println("Selected Triplet: seed='" + this.utils.seed.id + "' viewB='" + this.utils.viewB.id + "' viewC='" + this.utils.viewC.id + "' common.size=" + this.utils.commonIdx.size + " connections.size=" + seedConnIdx.size);
        }
        this.utils.createTripleFromCommon();
        if (!this.utils.estimateProjectiveCamerasRobustly()) {
            if (this.verbose != null) {
                this.verbose.println("failed to created projective from initial triplet");
            }
            return false;
        }
        this.createStructureLookUpTables(seed);
        if (seedConnIdx.size > 2) {
            this.initializeStructureForAllViews(db, this.utils.ransac.getMatchSet().size(), seed, seedConnIdx);
            if (!this.findRemainingCameraMatrices(db, seed, seedConnIdx)) {
                if (this.verbose != null) {
                    this.verbose.println("Finding remaining cameras failed. TODO recover from this");
                }
                return false;
            }
        } else {
            this.utils.initializeSbaSceneThreeView(true);
            this.utils.initializeSbaObservationsThreeView();
            this.viewsByStructureIndex.resize(3);
            this.viewsByStructureIndex.set(0, (Object)this.utils.seed);
            this.viewsByStructureIndex.set(1, (Object)this.utils.viewB);
            this.viewsByStructureIndex.set(2, (Object)this.utils.viewC);
        }
        this.viewsByStructureIndex.forIdx((i, o) -> BoofMiscOps.checkTrue((o != null ? 1 : 0) != 0));
        this.createObservationsForBundleAdjustment(seedConnIdx);
        return this.utils.refineWithBundleAdjustment();
    }

    private void initializeStructureForAllViews(LookUpSimilarImages db, int numberOfFeatures, PairwiseImageGraph.View seed, DogArray_I32 seedConnIdx) {
        this.utils.observations.initialize(1 + seedConnIdx.size);
        this.utils.structure.initialize(1 + seedConnIdx.size, numberOfFeatures);
        this.viewsByStructureIndex.resize(this.utils.structure.views.size, null);
        this.utils.triangulateFeatures();
        db.lookupShape(seed.id, this.shape);
        this.utils.structure.setView(0, true, this.utils.P1, this.shape.width, this.shape.height);
        int indexSbaViewB = 1 + seedConnIdx.indexOf(this.selectedTriple[0]);
        int indexSbaViewC = 1 + seedConnIdx.indexOf(this.selectedTriple[1]);
        BoofMiscOps.checkTrue((indexSbaViewB > 0 && indexSbaViewC > 0 ? 1 : 0) != 0, (String)"indexOf() failed");
        for (int i = 0; i < 2; ++i) {
            PairwiseImageGraph.Motion motion = (PairwiseImageGraph.Motion)seed.connections.get(this.selectedTriple[i]);
            PairwiseImageGraph.View view = motion.other(seed);
            db.lookupShape(view.id, this.shape);
            this.utils.structure.setView(i == 0 ? indexSbaViewB : indexSbaViewC, false, i == 0 ? this.utils.P2 : this.utils.P3, this.shape.width, this.shape.height);
        }
        this.viewsByStructureIndex.set(0, (Object)seed);
        this.viewsByStructureIndex.set(indexSbaViewB, (Object)this.utils.viewB);
        this.viewsByStructureIndex.set(indexSbaViewC, (Object)this.utils.viewC);
        SceneObservations.View view1 = this.utils.observations.getView(0);
        SceneObservations.View view2 = this.utils.observations.getView(indexSbaViewB);
        SceneObservations.View view3 = this.utils.observations.getView(indexSbaViewC);
        for (int i = 0; i < this.utils.inliersThreeView.size(); ++i) {
            AssociatedTriple t = this.utils.inliersThreeView.get(i);
            view1.add(i, (float)t.p1.x, (float)t.p1.y);
            view2.add(i, (float)t.p2.x, (float)t.p2.y);
            view3.add(i, (float)t.p3.x, (float)t.p3.y);
        }
    }

    void createStructureLookUpTables(PairwiseImageGraph.View viewA) {
        int numInliers = this.utils.ransac.getMatchSet().size();
        this.seedToStructure.resize(viewA.totalObservations);
        this.seedToStructure.fill(-1);
        this.inlierToSeed.resize(numInliers);
        for (int i = 0; i < numInliers; ++i) {
            int inputIdx = this.utils.ransac.getInputIndex(i);
            this.inlierToSeed.data[i] = this.utils.commonIdx.get(inputIdx);
            this.seedToStructure.data[this.inlierToSeed.data[i]] = i;
        }
    }

    boolean selectInitialTriplet(PairwiseImageGraph.View seed, DogArray_I32 edgeIdxs, int[] selected) {
        BoofMiscOps.checkTrue((selected.length == 2 ? 1 : 0) != 0);
        double bestScore = 0.0;
        for (int i = 0; i < edgeIdxs.size; ++i) {
            int edgeI = edgeIdxs.get(i);
            PairwiseImageGraph.View viewB = ((PairwiseImageGraph.Motion)seed.connections.get(edgeI)).other(seed);
            for (int j = i + 1; j < edgeIdxs.size; ++j) {
                int edgeJ = edgeIdxs.get(j);
                PairwiseImageGraph.View viewC = ((PairwiseImageGraph.Motion)seed.connections.get(edgeJ)).other(seed);
                double s = this.scoreTripleView(seed, viewB, viewC);
                if (!(s > bestScore)) continue;
                bestScore = s;
                selected[0] = edgeI;
                selected[1] = edgeJ;
            }
        }
        return bestScore != 0.0;
    }

    double scoreTripleView(PairwiseImageGraph.View seedA, PairwiseImageGraph.View viewB, PairwiseImageGraph.View viewC) {
        PairwiseImageGraph.Motion motionAB = seedA.findMotion(viewB);
        PairwiseImageGraph.Motion motionAC = seedA.findMotion(viewC);
        PairwiseImageGraph.Motion motionBC = viewB.findMotion(viewC);
        if (motionBC == null) {
            return 0.0;
        }
        double score = 0.0;
        score += this.utils.scoreMotion.score(motionAB);
        score += this.utils.scoreMotion.score(motionAC);
        return score += this.utils.scoreMotion.score(motionBC);
    }

    boolean findRemainingCameraMatrices(LookUpSimilarImages db, PairwiseImageGraph.View seed, DogArray_I32 seedConnIdx) {
        int i;
        BoofMiscOps.checkTrue((this.inlierToSeed.size == this.utils.inliersThreeView.size() ? 1 : 0) != 0);
        this.points3D.reset();
        for (i = 0; i < this.utils.structure.points.size; ++i) {
            ((SceneStructureCommon.Point[])this.utils.structure.points.data)[i].get((Point4D_F64)this.points3D.grow());
        }
        this.assocPixel.resize(this.inlierToSeed.size);
        for (i = 0; i < this.inlierToSeed.size; ++i) {
            ((AssociatedPair)this.assocPixel.get((int)i)).p1.setTo(this.utils.inliersThreeView.get((int)i).p1);
        }
        DMatrixRMaj cameraMatrix = new DMatrixRMaj(3, 4);
        for (int motionIdx = 0; motionIdx < seedConnIdx.size; ++motionIdx) {
            int connectionIdx = seedConnIdx.get(motionIdx);
            if (connectionIdx == this.selectedTriple[0] || connectionIdx == this.selectedTriple[1]) continue;
            PairwiseImageGraph.Motion edge = (PairwiseImageGraph.Motion)seed.connections.get(connectionIdx);
            PairwiseImageGraph.View viewI = edge.other(seed);
            db.lookupShape(viewI.id, this.utils.dimenB);
            db.lookupPixelFeats(viewI.id, this.utils.featsB);
            BoofMiscOps.offsetPixels((List)this.utils.featsB.toList(), (double)(-this.utils.dimenB.width / 2), (double)(-this.utils.dimenB.height / 2));
            if (!this.computeCameraMatrix(seed, edge, this.utils.featsB, cameraMatrix)) {
                if (this.verbose != null) {
                    this.verbose.println("Pose estimator failed! view='" + viewI.id + "'");
                }
                return false;
            }
            if (this.verbose != null) {
                this.verbose.println("Expanded initial scene to include view='" + viewI.id + "'");
            }
            int indexSbaView = motionIdx + 1;
            db.lookupShape(edge.other((PairwiseImageGraph.View)seed).id, this.shape);
            this.utils.structure.setView(indexSbaView, false, cameraMatrix, this.shape.width, this.shape.height);
            SceneObservations.View sbaObsView = this.utils.observations.getView(indexSbaView);
            BoofMiscOps.checkTrue((sbaObsView.size() == 0 ? 1 : 0) != 0, (String)"Must be reset to initial state first");
            for (int i2 = 0; i2 < this.inlierToSeed.size; ++i2) {
                Point2D_F64 p = ((AssociatedPair)this.assocPixel.get((int)i2)).p2;
                sbaObsView.add(i2, (float)p.x, (float)p.y);
            }
            this.viewsByStructureIndex.set(indexSbaView, (Object)viewI);
        }
        return true;
    }

    boolean computeCameraMatrix(PairwiseImageGraph.View seed, PairwiseImageGraph.Motion edge, DogArray<Point2D_F64> featsB, DMatrixRMaj cameraMatrix) {
        BoofMiscOps.checkTrue((this.assocPixel.size == this.inlierToSeed.size ? 1 : 0) != 0);
        PairwiseGraphUtils.createTableViewAtoB(seed, edge, this.utils.table_A_to_B);
        for (int i = 0; i < this.inlierToSeed.size; ++i) {
            int seedIdx = this.inlierToSeed.get(i);
            int dstIdx = this.utils.table_A_to_B.data[seedIdx];
            ((AssociatedPair)this.assocPixel.get((int)i)).p2.setTo((Point2D_F64)featsB.get(dstIdx));
        }
        if (this.utils.poseEstimator.processHomogenous(this.assocPixel.toList(), this.points3D.toList())) {
            cameraMatrix.set((DMatrixD1)this.utils.poseEstimator.getProjective());
            return true;
        }
        return false;
    }

    protected void createObservationsForBundleAdjustment(DogArray_I32 seedConnIdx) {
        this.utils.observations.initialize(seedConnIdx.size + 1);
        this.inlierIndexes.resize(seedConnIdx.size);
        SceneObservations.View obsView = this.utils.observations.getView(0);
        for (int i = 0; i < this.inlierToSeed.size; ++i) {
            int id = this.inlierToSeed.data[i];
            Point2D_F64 o = (Point2D_F64)this.utils.featsA.get(id);
            id = this.seedToStructure.data[id];
            obsView.add(id, (float)o.x, (float)o.y);
        }
        for (int motionIdx = 0; motionIdx < seedConnIdx.size(); ++motionIdx) {
            SceneObservations.View obsView2 = this.utils.observations.getView(motionIdx + 1);
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)this.utils.seed.connections.get(seedConnIdx.get(motionIdx));
            PairwiseImageGraph.View v = m.other(this.utils.seed);
            boolean seedIsSrc = m.src == this.utils.seed;
            this.utils.db.lookupShape(v.id, this.utils.dimenB);
            this.utils.db.lookupPixelFeats(v.id, this.utils.featsB);
            BoofMiscOps.offsetPixels((List)this.utils.featsB.toList(), (double)(-this.utils.dimenB.width / 2), (double)(-this.utils.dimenB.height / 2));
            DogArray_I32 connInlierIndexes = (DogArray_I32)this.inlierIndexes.get(motionIdx);
            connInlierIndexes.resize(this.inlierToSeed.size);
            for (int epipolarInlierIdx = 0; epipolarInlierIdx < m.inliers.size; ++epipolarInlierIdx) {
                AssociatedIndex a = (AssociatedIndex)m.inliers.get(epipolarInlierIdx);
                int structId = this.seedToStructure.data[seedIsSrc ? a.src : a.dst];
                if (structId < 0) continue;
                connInlierIndexes.set(structId, seedIsSrc ? a.dst : a.src);
                Point2D_F64 o = (Point2D_F64)this.utils.featsB.get(seedIsSrc ? a.dst : a.src);
                obsView2.add(structId, (float)o.x, (float)o.y);
            }
        }
    }

    public void lookupInfoForMetricElevation(List<String> viewIds, DogArray<ImageDimension> dimensions, DogArray<DMatrixRMaj> cameraMatrices, DogArray<AssociatedTupleDN> observations) {
        int numViews = this.utils.structure.views.size;
        viewIds.clear();
        dimensions.resize(numViews);
        cameraMatrices.resize(numViews - 1);
        observations.resize(this.inlierToSeed.size);
        for (int obsIdx = 0; obsIdx < observations.size; ++obsIdx) {
            ((AssociatedTupleDN)observations.get(obsIdx)).resize(numViews);
        }
        for (int viewIdx = 0; viewIdx < numViews; ++viewIdx) {
            if (viewIdx != 0) {
                ((DMatrixRMaj)cameraMatrices.get(viewIdx - 1)).set((DMatrixD1)((SceneStructureProjective.View)this.utils.structure.views.get((int)viewIdx)).worldToView);
            }
            String id = ((PairwiseImageGraph.View)this.viewsByStructureIndex.get((int)viewIdx)).id;
            viewIds.add(id);
            this.utils.db.lookupShape(id, (ImageDimension)dimensions.get(viewIdx));
            SceneObservations.View oview = (SceneObservations.View)this.utils.observations.views.get(viewIdx);
            BoofMiscOps.checkTrue((oview.size() == observations.size ? 1 : 0) != 0);
            for (int obsIdx = 0; obsIdx < observations.size; ++obsIdx) {
                oview.get(obsIdx, ((AssociatedTupleDN)observations.get(obsIdx)).get(viewIdx));
            }
        }
    }

    public SceneStructureProjective getStructure() {
        return this.utils.structure;
    }

    public PairwiseImageGraph.View getPairwiseGraphViewByStructureIndex(int index) {
        return (PairwiseImageGraph.View)this.viewsByStructureIndex.get(index);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public PairwiseGraphUtils getUtils() {
        return this.utils;
    }

    public void setUtils(PairwiseGraphUtils utils) {
        this.utils = utils;
    }

    public DogArray_I32 getInlierToSeed() {
        return this.inlierToSeed;
    }

    public DogArray<DogArray_I32> getInlierIndexes() {
        return this.inlierIndexes;
    }
}

