/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.ImageDimension;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class RefineMetricWorkingGraph
implements VerbosePrint {
    public double maxReprojectionErrorPixel = 1.0E100;
    public final MetricBundleAdjustmentUtils bundleAdjustment = new MetricBundleAdjustmentUtils();
    protected final List<Point2Transform2_F64> listPixelToNorm = new ArrayList<Point2Transform2_F64>();
    protected final List<Point2Transform2_F64> listNormToPixel = new ArrayList<Point2Transform2_F64>();
    TObjectIntHashMap<String> viewToIntegerID = new TObjectIntHashMap();
    private PrintStream verbose;
    protected final DogArray<Point2D_F64> pixels = new DogArray(Point2D_F64::new);
    protected final DogArray<Point2D_F64> pixelNormalized = new DogArray(Point2D_F64::new);
    protected final DogArray<Se3_F64> listPoses = new DogArray(Se3_F64::new);
    protected final Se3_F64 view0_to_world = new Se3_F64();
    final DogArray_I32 unassigned = new DogArray_I32();
    final DogArray_I32 featureIdx3D = new DogArray_I32();
    final DogArray_I32 viewIntIds = new DogArray_I32();
    private final Point2D_F64 pixelObserved = new Point2D_F64();
    private final Point2D_F64 pixelPredicted = new Point2D_F64();
    private final Point4D_F64 world3D = new Point4D_F64();
    private final Point4D_F64 camera3D = new Point4D_F64();
    private final Point4D_F64 found3D = new Point4D_F64();

    public boolean process(LookUpSimilarImages db, SceneWorkingGraph graph) {
        this.initializeDataStructures(db, graph);
        this.createFeatures3D(graph);
        this.pruneUnassignedObservations();
        return this.refineViews(graph);
    }

    void initializeDataStructures(LookUpSimilarImages db, SceneWorkingGraph graph) {
        this.viewToIntegerID.clear();
        this.listPixelToNorm.clear();
        this.listNormToPixel.clear();
        SceneStructureMetric structure = this.bundleAdjustment.structure;
        SceneObservations observations = this.bundleAdjustment.observations;
        structure.initialize(graph.viewList.size(), graph.viewList.size(), 0);
        observations.initialize(graph.viewList.size());
        for (int viewIdx = 0; viewIdx < graph.viewList.size(); ++viewIdx) {
            SceneWorkingGraph.View wview = graph.viewList.get(viewIdx);
            SceneObservations.View oview = observations.getView(viewIdx);
            this.viewToIntegerID.put((Object)wview.pview.id, viewIdx);
            this.createProjectionModel(wview.intrinsic);
            oview.resize(wview.pview.totalObservations);
            db.lookupPixelFeats(wview.pview.id, this.pixels);
            BoofMiscOps.checkEq((int)this.pixels.size, (int)wview.pview.totalObservations);
            ImageDimension dimension = wview.imageDimension;
            BoofMiscOps.checkTrue((dimension.width > 0 ? 1 : 0) != 0, (String)"You must assign width and height so that pixels can be re-centered");
            float cx = dimension.width / 2;
            float cy = dimension.height / 2;
            for (int obsIdx = 0; obsIdx < this.pixels.size; ++obsIdx) {
                Point2D_F64 p = (Point2D_F64)this.pixels.get(obsIdx);
                oview.setPixel(obsIdx, (float)(p.x - (double)cx), (float)(p.y - (double)cy));
            }
            structure.setCamera(viewIdx, false, (BundleAdjustmentCamera)wview.intrinsic);
            structure.setView(viewIdx, viewIdx, viewIdx == 0, wview.world_to_view);
        }
    }

    void createFeatures3D(SceneWorkingGraph graph) {
        for (int sceneViewIdx = 0; sceneViewIdx < graph.viewList.size(); ++sceneViewIdx) {
            SceneWorkingGraph.View wview = graph.viewList.get(sceneViewIdx);
            if (wview.inliers.isEmpty()) continue;
            SceneWorkingGraph.InlierInfo inliers = wview.inliers;
            FastArray<PairwiseImageGraph.View> inlierViews = inliers.views;
            this.initLookUpTablesForInlierSet(graph, inlierViews);
            int numInliers = wview.inliers.getInlierCount();
            if (this.verbose != null) {
                this.verbose.println("Inlier view='" + wview.pview.id + "' inliers=" + numInliers);
            }
            int countMatched = 0;
            int countMixed = 0;
            int tooFew = 0;
            for (int inlierIdx = 0; inlierIdx < numInliers; ++inlierIdx) {
                this.findUnassignedObsAndKnown3D(inliers, inlierIdx);
                if (this.unassigned.size != 0 && this.featureIdx3D.size != 0) {
                    ++countMixed;
                } else if (this.featureIdx3D.size != 0) {
                    ++countMatched;
                }
                if (this.featureIdx3D.size > 0) {
                    this.assignKnown3DToUnassignedObs(graph, inliers, inlierIdx);
                }
                if (this.unassigned.size < 2) {
                    ++tooFew;
                    continue;
                }
                this.triangulateAndSave(inliers, inlierIdx);
            }
            if (this.verbose == null) continue;
            this.verbose.println("   unmatched=" + (numInliers - countMatched) + "  matched=" + countMatched + " mixed=" + countMixed + " tooFew=" + tooFew);
        }
    }

    void initLookUpTablesForInlierSet(SceneWorkingGraph graph, FastArray<PairwiseImageGraph.View> inlierViews) {
        this.pixelNormalized.resize(inlierViews.size);
        this.viewIntIds.reset();
        this.listPoses.resize(inlierViews.size);
        Se3_F64 world_to_view0 = graph.views.get((Object)((PairwiseImageGraph.View)inlierViews.get((int)0)).id).world_to_view;
        world_to_view0.invert(this.view0_to_world);
        for (int i = 0; i < inlierViews.size; ++i) {
            String viewID = ((PairwiseImageGraph.View)inlierViews.get((int)i)).id;
            this.viewIntIds.add(this.viewToIntegerID.get((Object)viewID));
            this.view0_to_world.concat(graph.views.get((Object)viewID).world_to_view, (Se3_F64)this.listPoses.get(i));
        }
    }

    void assignKnown3DToUnassignedObs(SceneWorkingGraph graph, SceneWorkingGraph.InlierInfo inliers, int inlierIdx) {
        SceneStructureMetric structure = this.bundleAdjustment.structure;
        SceneObservations observations = this.bundleAdjustment.observations;
        for (int unassignedIdx = this.unassigned.size - 1; unassignedIdx >= 0; --unassignedIdx) {
            int whichViewInliers = this.unassigned.get(unassignedIdx);
            int whichViewID = this.viewIntIds.get(whichViewInliers);
            int viewObsIdx = ((DogArray_I32)inliers.observations.get(whichViewInliers)).get(inlierIdx);
            observations.getView(whichViewID).get(viewObsIdx, this.pixelObserved);
            SceneWorkingGraph.View wview = graph.viewList.get(whichViewID);
            Point2Transform2_F64 normToPixels = this.listNormToPixel.get(whichViewID);
            double bestScore = this.maxReprojectionErrorPixel * this.maxReprojectionErrorPixel;
            int bestId = -1;
            for (int knownIdx = 0; knownIdx < this.featureIdx3D.size; ++knownIdx) {
                int featureId = this.featureIdx3D.get(knownIdx);
                ((SceneStructureCommon.Point)structure.getPoints().get(featureId)).get(this.world3D);
                double error = this.computeReprojectionError(wview.world_to_view, normToPixels, this.pixelObserved, this.world3D);
                if (!(error <= bestScore)) continue;
                bestScore = error;
                bestId = featureId;
            }
            if (bestId == -1) {
                if (this.verbose == null) continue;
                this.verbose.println("Not matching. Reprojection error too large view=" + whichViewID);
                continue;
            }
            observations.getView((int)whichViewID).point.set(viewObsIdx, bestId);
            structure.connectPointToView(bestId, whichViewID);
            this.unassigned.remove(unassignedIdx);
        }
    }

    double computeReprojectionError(Se3_F64 world_to_view, Point2Transform2_F64 normToPixels, Point2D_F64 pixelObs, Point4D_F64 world3D) {
        SePointOps_F64.transform((Se3_F64)world_to_view, (Point4D_F64)world3D, (Point4D_F64)this.camera3D);
        double normX = this.camera3D.x / this.camera3D.z;
        double normY = this.camera3D.y / this.camera3D.z;
        normToPixels.compute(normX, normY, this.pixelPredicted);
        return pixelObs.distance2((GeoTuple2D_F64)this.pixelPredicted);
    }

    void findUnassignedObsAndKnown3D(SceneWorkingGraph.InlierInfo inliers, int inlierIdx) {
        this.unassigned.reset();
        this.featureIdx3D.reset();
        for (int inlierViewIdx = 0; inlierViewIdx < this.viewIntIds.size; ++inlierViewIdx) {
            int obsIdx = ((DogArray_I32)inliers.observations.get(inlierViewIdx)).get(inlierIdx);
            int featIdx = ((SceneObservations.View)this.bundleAdjustment.observations.views.get(this.viewIntIds.get(inlierViewIdx))).getPointId(obsIdx);
            if (featIdx >= 0) {
                if (this.featureIdx3D.contains(featIdx)) continue;
                this.featureIdx3D.add(featIdx);
                continue;
            }
            this.unassigned.add(inlierViewIdx);
        }
    }

    void createProjectionModel(BundlePinholeSimplified intrinsic) {
        CameraPinholeBrown brown = new CameraPinholeBrown();
        BundleAdjustmentOps.convert((BundlePinholeSimplified)intrinsic, (int)0, (int)0, (CameraPinholeBrown)brown);
        LensDistortionNarrowFOV model = LensDistortionFactory.narrow((CameraModel)brown);
        this.listPixelToNorm.add(model.undistort_F64(true, false));
        this.listNormToPixel.add(model.distort_F64(false, true));
    }

    void triangulateAndSave(SceneWorkingGraph.InlierInfo inliers, int inlierIdx) {
        SceneStructureMetric structure = this.bundleAdjustment.structure;
        SceneObservations observations = this.bundleAdjustment.observations;
        TriangulateNViewsMetricH triangulator = this.bundleAdjustment.triangulator;
        for (int inlierViewIdx = 0; inlierViewIdx < this.viewIntIds.size; ++inlierViewIdx) {
            int viewID = this.viewIntIds.get(inlierViewIdx);
            int obsIdx = ((DogArray_I32)inliers.observations.get(inlierViewIdx)).get(inlierIdx);
            observations.getView(viewID).get(obsIdx, this.pixelObserved);
            this.listPixelToNorm.get(viewID).compute(this.pixelObserved.x, this.pixelObserved.y, (Point2D_F64)this.pixelNormalized.get(inlierViewIdx));
        }
        if (!triangulator.triangulate(this.pixelNormalized.toList(), this.listPoses.toList(), this.found3D)) {
            return;
        }
        SePointOps_F64.transform((Se3_F64)this.view0_to_world, (Point4D_F64)this.found3D, (Point4D_F64)this.found3D);
        int pointID = structure.points.size;
        SceneStructureCommon.Point point3D = (SceneStructureCommon.Point)structure.points.grow();
        if (structure.isHomogenous()) {
            point3D.set(this.found3D.x, this.found3D.y, this.found3D.z, this.found3D.w);
        } else {
            point3D.set(this.found3D.x / this.found3D.w, this.found3D.y / this.found3D.w, this.found3D.z / this.found3D.w);
        }
        for (int i = 0; i < this.unassigned.size; ++i) {
            int inlierViewIdx = this.unassigned.get(i);
            int obsIdx = ((DogArray_I32)inliers.observations.get(inlierViewIdx)).get(inlierIdx);
            int viewID = this.viewIntIds.get(inlierViewIdx);
            observations.getView((int)viewID).point.set(obsIdx, pointID);
            point3D.views.add(viewID);
        }
    }

    void pruneUnassignedObservations() {
        SceneObservations observations = this.bundleAdjustment.observations;
        for (int i = 0; i < observations.views.size; ++i) {
            SceneObservations.View v = (SceneObservations.View)observations.views.get(i);
            for (int j = v.point.size() - 1; j >= 0; --j) {
                if (v.point.get(j) != -1) continue;
                v.point.data[j] = v.point.removeTail();
                v.observations.data[j * 2] = v.observations.getTail(1);
                v.observations.data[j * 2 + 1] = v.observations.getTail(0);
                v.observations.size -= 2;
            }
        }
    }

    protected boolean refineViews(SceneWorkingGraph graph) {
        if (this.verbose != null) {
            this.bundleAdjustment.printCounts(this.verbose);
        }
        if (!this.bundleAdjustment.process(this.verbose)) {
            return false;
        }
        SceneStructureMetric structure = this.bundleAdjustment.structure;
        for (int viewIdx = 0; viewIdx < graph.viewList.size(); ++viewIdx) {
            SceneWorkingGraph.View wview = graph.viewList.get(viewIdx);
            wview.world_to_view.setTo(structure.getParentToView(viewIdx));
            wview.intrinsic.setTo((BundlePinholeSimplified)((SceneStructureCommon.Camera)structure.cameras.get((int)viewIdx)).model);
        }
        return true;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }
}

