/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.mvs;

import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.describe.ConfigDescribeRegionPoint;
import boofcv.factory.feature.detect.selector.ConfigSelectLimit;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.pyramid.ConfigDiscreteLevels;

public class ConfigSelectFrames3D
implements Configuration {
    public int historyLength = 5;
    public double motionInlierPx = 2.0;
    public double thresholdQuick = 0.1;
    public double threshold3D = 0.5;
    public int minimumPairs = 100;
    public int robustIterations = 50;
    public double skipEvidenceRatio = 1.5;
    public final ConfigLength minTranslation = ConfigLength.relative((double)0.01, (double)0.0);
    public final ConfigLength maxTranslation = ConfigLength.relative((double)0.15, (double)20.0);
    public final ConfigLength featureRadius = ConfigLength.fixed((double)10.0);
    public final ConfigPointTracker tracker = new ConfigPointTracker();
    public final ConfigDescribeRegionPoint describe = new ConfigDescribeRegionPoint();
    public final ConfigAssociate associate = new ConfigAssociate();

    public ConfigSelectFrames3D() {
        this.tracker.klt.pruneClose = true;
        this.tracker.klt.pyramidLevels.setTo(ConfigDiscreteLevels.minSize((int)40));
        this.tracker.klt.toleranceFB = 2.0;
        this.tracker.klt.templateRadius = 3;
        this.tracker.klt.config.maxIterations = 25;
        this.tracker.klt.maximumTracks.setRelative(0.002, 800.0);
        this.tracker.typeTracker = ConfigPointTracker.TrackerType.KLT;
        this.tracker.detDesc.detectPoint.general.selector.setTo(ConfigSelectLimit.selectUniform((double)3.0));
        this.describe.type = ConfigDescribeRegionPoint.DescriptorType.SURF_STABLE;
        this.associate.maximumDistancePixels.setRelative(0.25, 50.0);
        this.associate.greedy.forwardsBackwards = true;
        this.associate.greedy.scoreRatioThreshold = 0.9;
        this.associate.type = ConfigAssociate.AssociationType.GREEDY;
    }

    public void checkValidity() {
        BoofMiscOps.checkTrue((this.historyLength >= 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.motionInlierPx >= 0.0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.thresholdQuick >= 0.0 && this.thresholdQuick <= 1.0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.threshold3D >= 0.0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.minimumPairs >= 1 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.robustIterations >= 1 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.skipEvidenceRatio >= 0.0 ? 1 : 0) != 0);
        this.minTranslation.checkValidity();
        this.maxTranslation.checkValidity();
        this.featureRadius.checkValidity();
        this.tracker.checkValidity();
        this.describe.checkValidity();
        this.associate.checkValidity();
    }

    public void setTo(ConfigSelectFrames3D src) {
        this.historyLength = src.historyLength;
        this.motionInlierPx = src.motionInlierPx;
        this.thresholdQuick = src.thresholdQuick;
        this.threshold3D = src.threshold3D;
        this.minimumPairs = src.minimumPairs;
        this.robustIterations = src.robustIterations;
        this.skipEvidenceRatio = src.skipEvidenceRatio;
        this.minTranslation.setTo(src.minTranslation);
        this.maxTranslation.setTo(src.maxTranslation);
        this.featureRadius.setTo(src.featureRadius);
        this.tracker.setTo(src.tracker);
        this.describe.setTo(src.describe);
        this.associate.setTo(src.associate);
    }
}

