/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthParametersCreator<T extends AuthenticationParametersWithIV>
implements ParametersCreator,
MacParametersCreator {
    private final AuthenticationParametersWithIV<AuthenticationParametersWithIV> baseParameters;

    AuthParametersCreator(AuthenticationParametersWithIV authenticationParametersWithIV) {
        this.baseParameters = authenticationParametersWithIV;
    }

    public AuthenticationParameters getBaseParameters() {
        return this.baseParameters;
    }

    public AuthenticationParameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            AEADParameterSpec aEADParameterSpec = (AEADParameterSpec)algorithmParameterSpec;
            return (AuthenticationParameters)((AuthenticationParametersWithIV)this.baseParameters.withIV(aEADParameterSpec.getNonce())).withMACSize(aEADParameterSpec.getMacSizeInBits());
        }
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            return (AuthenticationParameters)this.baseParameters.withIV(((IvParameterSpec)algorithmParameterSpec).getIV());
        }
        if (GcmSpecUtil.isGcmSpec(algorithmParameterSpec)) {
            try {
                GCMParameters gCMParameters = GcmSpecUtil.extractGcmParameters(algorithmParameterSpec);
                return (AuthenticationParameters)((AuthenticationParametersWithIV)this.baseParameters.withIV(gCMParameters.getNonce())).withMACSize(gCMParameters.getIcvLen() * 8);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec: " + exception.getMessage(), exception);
            }
        }
        if (bl && this.baseParameters.getAlgorithm().requiresAlgorithmParameters()) {
            return (AuthenticationParameters)this.baseParameters.withIV(secureRandom);
        }
        return this.baseParameters;
    }
}

