/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPUtil;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.util.Arrays;

public abstract class PBEKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    private char[] passPhrase;
    private PGPDigestCalculator s2kDigestCalculator;
    private S2K s2k;
    private SecureRandom random;
    private int s2kCount;
    private int wrapAlg = -1;

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        this(cArray, pGPDigestCalculator, 96);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        this.passPhrase = cArray;
        this.s2k = new S2K(argon2Params);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        this.passPhrase = cArray;
        this.s2kDigestCalculator = pGPDigestCalculator;
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = n;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PBEKeyEncryptionMethodGenerator setSessionKeyWrapperAlgorithm(int n) {
        this.wrapAlg = n;
        return this;
    }

    public int getSessionKeyWrapperAlgorithm(int n) {
        if (this.wrapAlg < 0) {
            return n;
        }
        return this.wrapAlg;
    }

    public byte[] getKey(int n) throws PGPException {
        if (this.s2k == null) {
            byte[] byArray = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), byArray, this.s2kCount);
        }
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, n, this.s2k, this.passPhrase);
    }

    @Override
    public ContainedPacket generateV5(int n, int n2, byte[] byArray) throws PGPException {
        return this.generate(n, byArray);
    }

    @Override
    public ContainedPacket generateV6(int n, int n2, byte[] byArray) throws PGPException {
        return this.generateV6ESK(n, n2, byArray);
    }

    private ContainedPacket generateV5ESK(int n, int n2, byte[] byArray) throws PGPException {
        byte[] byArray2 = this.getKey(n);
        byte[] byArray3 = new byte[]{-61, 5, (byte)n, (byte)n2};
        byte[] byArray4 = new byte[AEADUtils.getIVLength(n2)];
        this.random.nextBytes(byArray4);
        int n3 = AEADUtils.getAuthTagLength(n2);
        byte[] byArray5 = this.getEskAndTag(n, n2, byArray, byArray2, byArray4, byArray3);
        byte[] byArray6 = Arrays.copyOfRange((byte[])byArray5, (int)0, (int)(byArray5.length - n3));
        byte[] byArray7 = Arrays.copyOfRange((byte[])byArray5, (int)byArray6.length, (int)byArray5.length);
        return SymmetricKeyEncSessionPacket.createV5Packet(n, n2, byArray4, this.s2k, byArray6, byArray7);
    }

    private ContainedPacket generateV6ESK(int n, int n2, byte[] byArray) throws PGPException {
        byte[] byArray2 = this.getKey(n);
        byte[] byArray3 = new byte[]{-61, 6, (byte)n, (byte)n2};
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hKDFBytesGenerator.init((DerivationParameters)new HKDFParameters(byArray2, null, byArray3));
        int n3 = SymmetricKeyUtils.getKeyLengthInOctets(n);
        byte[] byArray4 = new byte[n3];
        hKDFBytesGenerator.generateBytes(byArray4, 0, byArray4.length);
        byte[] byArray5 = new byte[AEADUtils.getIVLength(n2)];
        this.random.nextBytes(byArray5);
        int n4 = AEADUtils.getAuthTagLength(n2);
        byte[] byArray6 = this.getEskAndTag(n, n2, byArray, byArray4, byArray5, byArray3);
        byte[] byArray7 = Arrays.copyOfRange((byte[])byArray6, (int)0, (int)(byArray6.length - n4));
        byte[] byArray8 = Arrays.copyOfRange((byte[])byArray6, (int)byArray7.length, (int)byArray6.length);
        return SymmetricKeyEncSessionPacket.createV6Packet(n, n2, byArray5, this.s2k, byArray7, byArray8);
    }

    private byte[] getEskAndTag(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws PGPException {
        byte[] byArray5 = new byte[byArray.length - 3];
        System.arraycopy(byArray, 1, byArray5, 0, byArray5.length);
        AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n, n2);
        aEADBlockCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(byArray2), 128, byArray3, byArray4));
        int n3 = aEADBlockCipher.getOutputSize(byArray5.length);
        byte[] byArray6 = new byte[n3];
        int n4 = aEADBlockCipher.processBytes(byArray5, 0, byArray5.length, byArray6, 0);
        try {
            n4 += aEADBlockCipher.doFinal(byArray6, n4);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("cannot encrypt session info", (Exception)((Object)invalidCipherTextException));
        }
        return byArray6;
    }

    @Override
    public ContainedPacket generate(int n, byte[] byArray) throws PGPException {
        if (byArray == null) {
            return SymmetricKeyEncSessionPacket.createV4Packet(n, this.s2k, null);
        }
        byte[] byArray2 = this.getKey(n);
        byte[] byArray3 = new byte[byArray.length - 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
        return SymmetricKeyEncSessionPacket.createV4Packet(n, this.s2k, this.encryptSessionInfo(n, byArray2, byArray3));
    }

    protected abstract byte[] encryptSessionInfo(int var1, byte[] var2, byte[] var3) throws PGPException;
}

