/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class PhotonBeetleEngine
implements AEADCipher {
    private boolean input_empty;
    private boolean forEncryption;
    private byte[] K;
    private byte[] N;
    private byte[] state;
    private byte[][] state_2d;
    private byte[] A;
    private byte[] T;
    private boolean encrypted;
    private boolean initialised;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();
    private final int CRYPTO_KEYBYTES = 16;
    private final int CRYPTO_NPUBBYTES = 16;
    private final int RATE_INBYTES;
    private final int RATE_INBYTES_HALF;
    private final int STATE_INBYTES;
    private final int TAG_INBYTES = 16;
    private final int LAST_THREE_BITS_OFFSET;
    private final int ROUND = 12;
    private final int D = 8;
    private final int Dq = 3;
    private final int Dr = 7;
    private final int DSquare = 64;
    private final int S = 4;
    private final int S_1 = 3;
    private final byte[][] RC = new byte[][]{{1, 3, 7, 14, 13, 11, 6, 12, 9, 2, 5, 10}, {0, 2, 6, 15, 12, 10, 7, 13, 8, 3, 4, 11}, {2, 0, 4, 13, 14, 8, 5, 15, 10, 1, 6, 9}, {6, 4, 0, 9, 10, 12, 1, 11, 14, 5, 2, 13}, {14, 12, 8, 1, 2, 4, 9, 3, 6, 13, 10, 5}, {15, 13, 9, 0, 3, 5, 8, 2, 7, 12, 11, 4}, {13, 15, 11, 2, 1, 7, 10, 0, 5, 14, 9, 6}, {9, 11, 15, 6, 5, 3, 14, 4, 1, 10, 13, 2}};
    private final byte[][] MixColMatrix = new byte[][]{{2, 4, 2, 11, 2, 8, 5, 6}, {12, 9, 8, 13, 7, 7, 5, 2}, {4, 4, 13, 13, 9, 4, 13, 9}, {1, 6, 5, 1, 12, 13, 15, 14}, {15, 12, 9, 13, 14, 5, 14, 13}, {9, 14, 5, 15, 4, 12, 9, 6}, {12, 2, 2, 10, 3, 1, 1, 14}, {15, 1, 13, 10, 5, 10, 2, 3}};
    private final byte[] sbox = new byte[]{12, 5, 6, 11, 9, 0, 10, 13, 3, 14, 15, 8, 4, 7, 1, 2};

    public PhotonBeetleEngine(PhotonBeetleParameters pbp) {
        int CAPACITY_INBITS = 0;
        int RATE_INBITS = 0;
        switch (pbp) {
            case pb32: {
                RATE_INBITS = 32;
                CAPACITY_INBITS = 224;
                break;
            }
            case pb128: {
                RATE_INBITS = 128;
                CAPACITY_INBITS = 128;
            }
        }
        this.RATE_INBYTES = RATE_INBITS + 7 >>> 3;
        this.RATE_INBYTES_HALF = this.RATE_INBYTES >>> 1;
        int STATE_INBITS = RATE_INBITS + CAPACITY_INBITS;
        this.STATE_INBYTES = STATE_INBITS + 7 >>> 3;
        this.LAST_THREE_BITS_OFFSET = STATE_INBITS - (this.STATE_INBYTES - 1 << 3) - 3;
        this.initialised = false;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Photon-Beetle AEAD init parameters must include an IV");
        }
        ParametersWithIV ivParams = (ParametersWithIV)params;
        this.N = ivParams.getIV();
        if (this.N == null || this.N.length != 16) {
            throw new IllegalArgumentException("Photon-Beetle AEAD requires exactly 16 bytes of IV");
        }
        if (!(ivParams.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Photon-Beetle AEAD init parameters must include a key");
        }
        KeyParameter key = (KeyParameter)ivParams.getParameters();
        this.K = key.getKey();
        if (this.K.length != 16) {
            throw new IllegalArgumentException("Photon-Beetle AEAD key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.state = new byte[this.STATE_INBYTES];
        this.state_2d = new byte[8][8];
        this.T = new byte[16];
        this.initialised = true;
        this.reset(false);
    }

    @Override
    public String getAlgorithmName() {
        return "Photon-Beetle AEAD";
    }

    @Override
    public void processAADByte(byte input) {
        this.aadData.write(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.aadData.write(input, inOff, len);
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.message.write(input, inOff, len);
        return 0;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int LastDBlocklen;
        int i;
        int Dlen_inblocks;
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        int len = this.message.size() - (this.forEncryption ? 0 : 16);
        if (this.forEncryption && len + 16 + outOff > output.length || !this.forEncryption && len + outOff > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] input = this.message.toByteArray();
        int inOff = 0;
        this.A = this.aadData.toByteArray();
        int adlen = this.A.length;
        if (adlen != 0 || len != 0) {
            this.input_empty = false;
        }
        byte c0 = this.select(len != 0, adlen % this.RATE_INBYTES == 0, (byte)3, (byte)4);
        byte c1 = this.select(adlen != 0, len % this.RATE_INBYTES == 0, (byte)5, (byte)6);
        if (adlen != 0) {
            Dlen_inblocks = (adlen + this.RATE_INBYTES - 1) / this.RATE_INBYTES;
            for (i = 0; i < Dlen_inblocks - 1; ++i) {
                this.PHOTON_Permutation();
                this.XOR(this.A, i * this.RATE_INBYTES, this.RATE_INBYTES);
            }
            this.PHOTON_Permutation();
            LastDBlocklen = adlen - i * this.RATE_INBYTES;
            this.XOR(this.A, i * this.RATE_INBYTES, LastDBlocklen);
            if (LastDBlocklen < this.RATE_INBYTES) {
                int n = LastDBlocklen;
                this.state[n] = (byte)(this.state[n] ^ 1);
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ c0 << this.LAST_THREE_BITS_OFFSET);
        }
        if (len != 0) {
            Dlen_inblocks = (len + this.RATE_INBYTES - 1) / this.RATE_INBYTES;
            for (i = 0; i < Dlen_inblocks - 1; ++i) {
                this.PHOTON_Permutation();
                this.rhoohr(output, outOff + i * this.RATE_INBYTES, input, inOff + i * this.RATE_INBYTES, this.RATE_INBYTES);
            }
            this.PHOTON_Permutation();
            LastDBlocklen = len - i * this.RATE_INBYTES;
            this.rhoohr(output, outOff + i * this.RATE_INBYTES, input, inOff + i * this.RATE_INBYTES, LastDBlocklen);
            if (LastDBlocklen < this.RATE_INBYTES) {
                int n = LastDBlocklen;
                this.state[n] = (byte)(this.state[n] ^ 1);
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ c1 << this.LAST_THREE_BITS_OFFSET);
        }
        outOff += len;
        if (this.input_empty) {
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ 1 << this.LAST_THREE_BITS_OFFSET);
        }
        this.PHOTON_Permutation();
        this.T = new byte[16];
        System.arraycopy(this.state, 0, this.T, 0, 16);
        if (this.forEncryption) {
            System.arraycopy(this.T, 0, output, outOff, 16);
            len += 16;
        } else {
            for (i = 0; i < 16; ++i) {
                if (this.T[i] == input[len + i]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.reset(false);
        return len;
    }

    @Override
    public byte[] getMac() {
        return this.T;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + 16;
    }

    @Override
    public void reset() {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.reset(true);
    }

    private void reset(boolean clearMac) {
        if (clearMac) {
            this.T = null;
        }
        this.input_empty = true;
        this.aadData.reset();
        this.message.reset();
        System.arraycopy(this.K, 0, this.state, 0, this.K.length);
        System.arraycopy(this.N, 0, this.state, this.K.length, this.N.length);
        this.encrypted = false;
    }

    private void PHOTON_Permutation() {
        int i;
        for (i = 0; i < 64; ++i) {
            this.state_2d[i >>> 3][i & 7] = (byte)((this.state[i >> 1] & 0xFF) >>> 4 * (i & 1) & 0xF);
        }
        for (int round = 0; round < 12; ++round) {
            int j;
            for (i = 0; i < 8; ++i) {
                byte[] byArray = this.state_2d[i];
                byArray[0] = (byte)(byArray[0] ^ this.RC[i][round]);
            }
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    this.state_2d[i][j] = this.sbox[this.state_2d[i][j]];
                }
            }
            for (i = 1; i < 8; ++i) {
                System.arraycopy(this.state_2d[i], 0, this.state, 0, 8);
                System.arraycopy(this.state, i, this.state_2d[i], 0, 8 - i);
                System.arraycopy(this.state, 0, this.state_2d[i], 8 - i, i);
            }
            for (j = 0; j < 8; ++j) {
                for (i = 0; i < 8; ++i) {
                    byte sum = 0;
                    for (int k = 0; k < 8; ++k) {
                        int x = this.MixColMatrix[i][k];
                        int ret = 0;
                        byte b = this.state_2d[k][j];
                        for (int l = 0; l < 4; ++l) {
                            if ((b >>> l & 1) != 0) {
                                ret ^= x;
                            }
                            if ((x >>> 3 & 1) != 0) {
                                x <<= 1;
                                x ^= 3;
                                continue;
                            }
                            x <<= 1;
                        }
                        sum = (byte)(sum ^ ret & 0xF);
                    }
                    this.state[i] = sum;
                }
                for (i = 0; i < 8; ++i) {
                    this.state_2d[i][j] = this.state[i];
                }
            }
        }
        for (i = 0; i < 64; i += 2) {
            this.state[i >>> 1] = (byte)(this.state_2d[i >>> 3][i & 7] & 0xF | (this.state_2d[i >>> 3][i + 1 & 7] & 0xF) << 4);
        }
    }

    private byte select(boolean condition1, boolean condition2, byte option3, byte option4) {
        if (condition1 && condition2) {
            return 1;
        }
        if (condition1) {
            return 2;
        }
        if (condition2) {
            return option3;
        }
        return option4;
    }

    private void rhoohr(byte[] ciphertext, int outOff, byte[] plaintext, int inOff, int DBlen_inbytes) {
        int i;
        byte[] OuterState_part1_ROTR1 = this.state_2d[0];
        int loop_end = Math.min(DBlen_inbytes, this.RATE_INBYTES_HALF);
        for (i = 0; i < this.RATE_INBYTES_HALF - 1; ++i) {
            OuterState_part1_ROTR1[i] = (byte)((this.state[i] & 0xFF) >>> 1 | (this.state[i + 1] & 1) << 7);
        }
        OuterState_part1_ROTR1[this.RATE_INBYTES_HALF - 1] = (byte)((this.state[i] & 0xFF) >>> 1 | (this.state[0] & 1) << 7);
        i = 0;
        while (i < loop_end) {
            ciphertext[i + outOff] = (byte)(this.state[i + this.RATE_INBYTES_HALF] ^ plaintext[i++ + inOff]);
        }
        while (i < DBlen_inbytes) {
            ciphertext[i + outOff] = (byte)(OuterState_part1_ROTR1[i - this.RATE_INBYTES_HALF] ^ plaintext[i++ + inOff]);
        }
        if (this.forEncryption) {
            this.XOR(plaintext, inOff, DBlen_inbytes);
        } else {
            this.XOR(ciphertext, inOff, DBlen_inbytes);
        }
    }

    private void XOR(byte[] in_right, int rOff, int iolen_inbytes) {
        int i = 0;
        while (i < iolen_inbytes) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ in_right[rOff++]);
        }
    }

    public int getBlockSize() {
        return this.RATE_INBYTES;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    public static enum PhotonBeetleParameters {
        pb32,
        pb128;

    }
}

