/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.pqc.asn1.CMCEPublicKey;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CMCEPrivateKey
extends ASN1Object {
    private int version;
    private byte[] delta;
    private byte[] C;
    private byte[] g;
    private byte[] alpha;
    private byte[] s;
    private CMCEPublicKey PublicKey;

    public CMCEPrivateKey(int version, byte[] delta, byte[] c, byte[] g, byte[] alpha, byte[] s) {
        this(version, delta, c, g, alpha, s, null);
    }

    public CMCEPrivateKey(int version, byte[] delta, byte[] c, byte[] g, byte[] alpha, byte[] s, CMCEPublicKey pubKey) {
        this.version = version;
        if (version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.delta = Arrays.clone(delta);
        this.C = Arrays.clone(c);
        this.g = Arrays.clone(g);
        this.alpha = Arrays.clone(alpha);
        this.s = Arrays.clone(s);
        this.PublicKey = pubKey;
    }

    private CMCEPrivateKey(ASN1Sequence seq) {
        this.version = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.delta = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.C = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        this.g = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(3)).getOctets());
        this.alpha = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(4)).getOctets());
        this.s = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(5)).getOctets());
        if (seq.size() == 7) {
            this.PublicKey = CMCEPublicKey.getInstance(seq.getObjectAt(6));
        }
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getDelta() {
        return Arrays.clone(this.delta);
    }

    public byte[] getC() {
        return Arrays.clone(this.C);
    }

    public byte[] getG() {
        return Arrays.clone(this.g);
    }

    public byte[] getAlpha() {
        return Arrays.clone(this.alpha);
    }

    public byte[] getS() {
        return Arrays.clone(this.s);
    }

    public CMCEPublicKey getPublicKey() {
        return this.PublicKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.version));
        v.add(new DEROctetString(this.delta));
        v.add(new DEROctetString(this.C));
        v.add(new DEROctetString(this.g));
        v.add(new DEROctetString(this.alpha));
        v.add(new DEROctetString(this.s));
        if (this.PublicKey != null) {
            v.add(new CMCEPublicKey(this.PublicKey.getT()));
        }
        return new DERSequence(v);
    }

    public static CMCEPrivateKey getInstance(Object o) {
        if (o instanceof CMCEPrivateKey) {
            return (CMCEPrivateKey)o;
        }
        if (o != null) {
            return new CMCEPrivateKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

