/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gemss;

abstract class Rem_GF2n {
    protected long mask;
    protected int ki;
    protected int ki64;

    Rem_GF2n() {
    }

    public abstract void rem_gf2n(long[] var1, int var2, long[] var3);

    public abstract void rem_gf2n_xor(long[] var1, int var2, long[] var3);

    public static class REM192_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int k3;
        private final int k364;
        private final int ki_k3;

        REM192_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.k3 = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.k364 = k364;
            this.mask = mask;
            this.ki_k3 = ki - k3;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q0 = Pol[2] >>> this.ki ^ Pol[3] << this.ki64;
            long Q1 = Pol[3] >>> this.ki ^ Pol[4] << this.ki64;
            long Q2 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64;
            P[p_cp + 1] = Pol[1] ^ Q1 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            P[p_cp + 2] = (Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3) & this.mask;
            P[p_cp] = Pol[0] ^ (Q0 ^= Q2 >>> this.ki_k3) ^ Q0 << this.k3;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q0 = Pol[2] >>> this.ki ^ Pol[3] << this.ki64;
            long Q1 = Pol[3] >>> this.ki ^ Pol[4] << this.ki64;
            long Q2 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64;
            int n = p_cp + 1;
            P[n] = P[n] ^ (Pol[1] ^ Q1 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            int n2 = p_cp + 2;
            P[n2] = P[n2] ^ (Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3) & this.mask;
            int n3 = p_cp;
            P[n3] = P[n3] ^ (Pol[0] ^ (Q0 ^= Q2 >>> this.ki_k3) ^ Q0 << this.k3);
        }
    }

    public static class REM288_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int k3;
        private final int k364;
        private final int k364ki;
        private final int k3_ki;

        public REM288_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.k3 = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.k364 = k364;
            this.mask = mask;
            this.k364ki = k364 + ki;
            this.k3_ki = k3 - ki;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q1 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long Q2 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            P[p_cp + 2] = Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3;
            long Q3 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            P[p_cp + 3] = Pol[3] ^ Q3 ^ Q2 >>> this.k364 ^ Q3 << this.k3;
            long Q4 = Pol[8] >>> this.ki;
            Q2 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64 ^ Q3 >>> this.k364ki ^ Q4 << this.k3_ki;
            P[p_cp + 4] = (Pol[4] ^ Q4 ^ Q3 >>> this.k364 ^ Q4 << this.k3) & this.mask;
            P[p_cp] = Pol[0] ^ Q2 ^ Q2 << this.k3;
            P[p_cp + 1] = Pol[1] ^ Q1 ^ Q1 << this.k3 ^ Q2 >>> this.k364;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q1 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long Q2 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            int n = p_cp + 2;
            P[n] = P[n] ^ (Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3);
            long Q3 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            int n2 = p_cp + 3;
            P[n2] = P[n2] ^ (Pol[3] ^ Q3 ^ Q2 >>> this.k364 ^ Q3 << this.k3);
            Q2 = Pol[8] >>> this.ki;
            int n3 = p_cp + 4;
            P[n3] = P[n3] ^ (Pol[4] ^ Q2 ^ Q3 >>> this.k364 ^ Q2 << this.k3) & this.mask;
            Q3 = Pol[4] >>> this.ki ^ Pol[5] << this.ki64 ^ Q3 >>> this.k364ki ^ Q2 << this.k3_ki;
            int n4 = p_cp;
            P[n4] = P[n4] ^ (Pol[0] ^ Q3 ^ Q3 << this.k3);
            int n5 = p_cp + 1;
            P[n5] = P[n5] ^ (Pol[1] ^ Q1 ^ Q1 << this.k3 ^ Q3 >>> this.k364);
        }
    }

    public static class REM384_SPECIALIZED358_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int k3;
        private final int k364;
        private final int k364ki;
        private final int k3_ki;

        public REM384_SPECIALIZED358_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.k3 = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.k364 = k364;
            this.mask = mask;
            this.k364ki = k364 + ki;
            this.k3_ki = k3 - ki;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q1 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long Q2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            P[p_cp + 2] = Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3;
            long Q3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            P[p_cp + 3] = Pol[3] ^ Q3 ^ Q2 >>> this.k364 ^ Q3 << this.k3;
            Q2 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            P[p_cp + 4] = Pol[4] ^ Q2 ^ Q3 >>> this.k364 ^ Q2 << this.k3;
            Q3 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long Q0 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ Q2 >>> this.k364ki ^ Q3 << this.k3_ki;
            P[p_cp + 5] = (Pol[5] ^ Q3 ^ Q2 >>> this.k364) & this.mask;
            P[p_cp] = Pol[0] ^ Q0 ^ Q0 << this.k3;
            P[p_cp + 1] = Pol[1] ^ Q1 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q1 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long Q2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            int n = p_cp + 2;
            P[n] = P[n] ^ (Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3);
            long Q3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            int n2 = p_cp + 3;
            P[n2] = P[n2] ^ (Pol[3] ^ Q3 ^ Q2 >>> this.k364 ^ Q3 << this.k3);
            Q2 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            int n3 = p_cp + 4;
            P[n3] = P[n3] ^ (Pol[4] ^ Q2 ^ Q3 >>> this.k364 ^ Q2 << this.k3);
            Q3 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            int n4 = p_cp + 5;
            P[n4] = P[n4] ^ (Pol[5] ^ Q3 ^ Q2 >>> this.k364) & this.mask;
            Q2 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ Q2 >>> this.k364ki ^ Q3 << this.k3_ki;
            int n5 = p_cp;
            P[n5] = P[n5] ^ (Pol[0] ^ Q2 ^ Q2 << this.k3);
            int n6 = p_cp + 1;
            P[n6] = P[n6] ^ (Pol[1] ^ Q1 ^ Q2 >>> this.k364 ^ Q1 << this.k3);
        }
    }

    public static class REM384_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int k3;
        private final int k364;
        private final int k364ki;
        private final int k3_ki;

        public REM384_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.k3 = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.k364 = k364;
            this.mask = mask;
            this.k364ki = k364 + ki;
            this.k3_ki = k3 - ki;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long Q3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long Q4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long Q5 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long Q0 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ Q3 >>> this.k364ki ^ Q4 << this.k3_ki;
            long Q1 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64 ^ Q4 >>> this.k364ki ^ Q5 << this.k3_ki;
            P[p_cp] = Pol[0] ^ Q0;
            P[p_cp + 1] = Pol[1] ^ Q1 ^ Q0 << this.k3;
            P[p_cp + 2] = Pol[2] ^ Q2 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            P[p_cp + 3] = Pol[3] ^ Q3 ^ Q1 >>> this.k364 ^ Q2 << this.k3;
            P[p_cp + 4] = Pol[4] ^ Q4 ^ Q2 >>> this.k364 ^ Q3 << this.k3;
            P[p_cp + 5] = (Pol[5] ^ Q5 ^ Q3 >>> this.k364) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long Q3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long Q4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long Q5 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long Q0 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64 ^ Q3 >>> this.k364ki ^ Q4 << this.k3_ki;
            long Q1 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64 ^ Q4 >>> this.k364ki ^ Q5 << this.k3_ki;
            int n = p_cp;
            P[n] = P[n] ^ (Pol[0] ^ Q0);
            int n2 = p_cp + 1;
            P[n2] = P[n2] ^ (Pol[1] ^ Q1 ^ Q0 << this.k3);
            int n3 = p_cp + 2;
            P[n3] = P[n3] ^ (Pol[2] ^ Q2 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            int n4 = p_cp + 3;
            P[n4] = P[n4] ^ (Pol[3] ^ Q3 ^ Q1 >>> this.k364 ^ Q2 << this.k3);
            int n5 = p_cp + 4;
            P[n5] = P[n5] ^ (Pol[4] ^ Q4 ^ Q2 >>> this.k364 ^ Q3 << this.k3);
            int n6 = p_cp + 5;
            P[n6] = P[n6] ^ (Pol[5] ^ Q5 ^ Q3 >>> this.k364) & this.mask;
        }
    }

    public static class REM384_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int k3;
        private final int k364;
        private final int ki_k3;

        public REM384_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.k3 = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.k364 = k364;
            this.mask = mask;
            this.ki_k3 = ki - k3;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q0 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long Q1 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long Q2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long Q3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long Q4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long Q5 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long R = Q0 ^ Q5 >>> this.ki_k3;
            P[p_cp] = Pol[0] ^ R ^ R << this.k3;
            P[p_cp + 1] = Pol[1] ^ Q1 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            P[p_cp + 2] = Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3;
            P[p_cp + 3] = Pol[3] ^ Q3 ^ Q2 >>> this.k364 ^ Q3 << this.k3;
            P[p_cp + 4] = Pol[4] ^ Q4 ^ Q3 >>> this.k364 ^ Q4 << this.k3;
            P[p_cp + 5] = (Pol[5] ^ Q5 ^ Q4 >>> this.k364 ^ Q5 << this.k3) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q0 = Pol[5] >>> this.ki ^ Pol[6] << this.ki64;
            long Q1 = Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long Q2 = Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long Q3 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long Q4 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long Q5 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long R = Q0 ^ Q5 >>> this.ki_k3;
            int n = p_cp;
            P[n] = P[n] ^ (Pol[0] ^ R ^ R << this.k3);
            int n2 = p_cp + 1;
            P[n2] = P[n2] ^ (Pol[1] ^ Q1 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            int n3 = p_cp + 2;
            P[n3] = P[n3] ^ (Pol[2] ^ Q2 ^ Q1 >>> this.k364 ^ Q2 << this.k3);
            int n4 = p_cp + 3;
            P[n4] = P[n4] ^ (Pol[3] ^ Q3 ^ Q2 >>> this.k364 ^ Q3 << this.k3);
            int n5 = p_cp + 4;
            P[n5] = P[n5] ^ (Pol[4] ^ Q4 ^ Q3 >>> this.k364 ^ Q4 << this.k3);
            int n6 = p_cp + 5;
            P[n6] = P[n6] ^ (Pol[5] ^ Q5 ^ Q4 >>> this.k364 ^ Q5 << this.k3) & this.mask;
        }
    }

    public static class REM402_SPECIALIZED_TRINOMIAL_GF2X
    extends Rem_GF2n {
        private final int k3;
        private final int k364;

        public REM402_SPECIALIZED_TRINOMIAL_GF2X(int k3, int ki, int ki64, int k364, long mask) {
            this.k3 = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.k364 = k364;
            this.mask = mask;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q3 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long Q4 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long Q5 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long Q6 = Pol[12] >>> this.ki;
            long Q0 = Q3 >>> 39 ^ Q4 << 25 ^ Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long Q1 = Q4 >>> 39 ^ Q5 << 25 ^ Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long Q2 = Q5 >>> 39 ^ Q6 << 25 ^ Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            P[p_cp] = Pol[0] ^ Q0;
            P[p_cp + 1] = Pol[1] ^ Q1;
            P[p_cp + 2] = Pol[2] ^ Q2 ^ Q0 << this.k3;
            P[p_cp + 3] = Pol[3] ^ Q3 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            P[p_cp + 4] = Pol[4] ^ Q4 ^ Q1 >>> this.k364 ^ Q2 << this.k3;
            P[p_cp + 5] = Pol[5] ^ Q5 ^ Q2 >>> this.k364 ^ Q3 << this.k3;
            P[p_cp + 6] = (Pol[6] ^ Q6 ^ Q3 >>> this.k364) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q3 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            long Q4 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long Q5 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long Q6 = Pol[12] >>> this.ki;
            long Q0 = Q3 >>> 39 ^ Q4 << 25 ^ Pol[6] >>> this.ki ^ Pol[7] << this.ki64;
            long Q1 = Q4 >>> 39 ^ Q5 << 25 ^ Pol[7] >>> this.ki ^ Pol[8] << this.ki64;
            long Q2 = Q5 >>> 39 ^ Q6 << 25 ^ Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            int n = p_cp;
            P[n] = P[n] ^ (Pol[0] ^ Q0);
            int n2 = p_cp + 1;
            P[n2] = P[n2] ^ (Pol[1] ^ Q1);
            int n3 = p_cp + 2;
            P[n3] = P[n3] ^ (Pol[2] ^ Q2 ^ Q0 << this.k3);
            int n4 = p_cp + 3;
            P[n4] = P[n4] ^ (Pol[3] ^ Q3 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            int n5 = p_cp + 4;
            P[n5] = P[n5] ^ (Pol[4] ^ Q4 ^ Q1 >>> this.k364 ^ Q2 << this.k3);
            int n6 = p_cp + 5;
            P[n6] = P[n6] ^ (Pol[5] ^ Q5 ^ Q2 >>> this.k364 ^ Q3 << this.k3);
            int n7 = p_cp + 6;
            P[n7] = P[n7] ^ (Pol[6] ^ Q6 ^ Q3 >>> this.k364) & this.mask;
        }
    }

    public static class REM544_PENTANOMIAL_GF2X
    extends Rem_GF2n {
        private final int k1;
        private final int k2;
        private final int k3;
        private final int k164;
        private final int k264;
        private final int k364;
        private final int ki_k3;
        private final int ki_k2;
        private final int ki_k1;

        public REM544_PENTANOMIAL_GF2X(int k1, int k2, int k3, int ki, int ki64, int k164, int k264, int k364, long mask) {
            this.k1 = k1;
            this.k2 = k2;
            this.k3 = k3;
            this.ki = ki;
            this.ki64 = ki64;
            this.k164 = k164;
            this.k264 = k264;
            this.k364 = k364;
            this.mask = mask;
            this.ki_k3 = ki - k3;
            this.ki_k2 = ki - k2;
            this.ki_k1 = ki - k1;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q8 = Pol[16] >>> this.ki;
            long Q0 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long Q1 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            P[p_cp + 1] = Pol[1] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            P[p_cp] = Pol[0] ^ (Q0 ^= Q8 >>> this.ki_k3 ^ Q8 >>> this.ki_k2 ^ Q8 >>> this.ki_k1) ^ Q0 << this.k1 ^ Q0 << this.k2 ^ Q0 << this.k3;
            Q0 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            P[p_cp + 2] = Pol[2] ^ Q0 ^ Q1 >>> this.k164 ^ Q0 << this.k1 ^ Q1 >>> this.k264 ^ Q0 << this.k2 ^ Q1 >>> this.k364 ^ Q0 << this.k3;
            Q1 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            P[p_cp + 3] = Pol[3] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            Q0 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            P[p_cp + 4] = Pol[4] ^ Q0 ^ Q1 >>> this.k164 ^ Q0 << this.k1 ^ Q1 >>> this.k264 ^ Q0 << this.k2 ^ Q1 >>> this.k364 ^ Q0 << this.k3;
            Q1 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            P[p_cp + 5] = Pol[5] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            Q0 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            P[p_cp + 6] = Pol[6] ^ Q0 ^ Q1 >>> this.k164 ^ Q0 << this.k1 ^ Q1 >>> this.k264 ^ Q0 << this.k2 ^ Q1 >>> this.k364 ^ Q0 << this.k3;
            Q1 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            P[p_cp + 7] = Pol[7] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3;
            P[p_cp + 8] = (Pol[8] ^ Q8 ^ Q1 >>> this.k164 ^ Q8 << this.k1 ^ Q1 >>> this.k264 ^ Q8 << this.k2 ^ Q1 >>> this.k364 ^ Q8 << this.k3) & this.mask;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q8 = Pol[16] >>> this.ki;
            long Q0 = Pol[8] >>> this.ki ^ Pol[9] << this.ki64;
            long Q1 = Pol[9] >>> this.ki ^ Pol[10] << this.ki64;
            int n = p_cp + 1;
            P[n] = P[n] ^ (Pol[1] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            int n2 = p_cp;
            P[n2] = P[n2] ^ (Pol[0] ^ (Q0 ^= Q8 >>> this.ki_k3 ^ Q8 >>> this.ki_k2 ^ Q8 >>> this.ki_k1) ^ Q0 << this.k1 ^ Q0 << this.k2 ^ Q0 << this.k3);
            Q0 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            int n3 = p_cp + 2;
            P[n3] = P[n3] ^ (Pol[2] ^ Q0 ^ Q1 >>> this.k164 ^ Q0 << this.k1 ^ Q1 >>> this.k264 ^ Q0 << this.k2 ^ Q1 >>> this.k364 ^ Q0 << this.k3);
            Q1 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            int n4 = p_cp + 3;
            P[n4] = P[n4] ^ (Pol[3] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            Q0 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            int n5 = p_cp + 4;
            P[n5] = P[n5] ^ (Pol[4] ^ Q0 ^ Q1 >>> this.k164 ^ Q0 << this.k1 ^ Q1 >>> this.k264 ^ Q0 << this.k2 ^ Q1 >>> this.k364 ^ Q0 << this.k3);
            Q1 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            int n6 = p_cp + 5;
            P[n6] = P[n6] ^ (Pol[5] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            Q0 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            int n7 = p_cp + 6;
            P[n7] = P[n7] ^ (Pol[6] ^ Q0 ^ Q1 >>> this.k164 ^ Q0 << this.k1 ^ Q1 >>> this.k264 ^ Q0 << this.k2 ^ Q1 >>> this.k364 ^ Q0 << this.k3);
            Q1 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            int n8 = p_cp + 7;
            P[n8] = P[n8] ^ (Pol[7] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2 ^ Q0 >>> this.k364 ^ Q1 << this.k3);
            int n9 = p_cp + 8;
            P[n9] = P[n9] ^ (Pol[8] ^ Q8 ^ Q1 >>> this.k164 ^ Q8 << this.k1 ^ Q1 >>> this.k264 ^ Q8 << this.k2 ^ Q1 >>> this.k364 ^ Q8 << this.k3) & this.mask;
        }
    }

    public static class REM544_PENTANOMIAL_K3_IS_128_GF2X
    extends Rem_GF2n {
        private final int k1;
        private final int k2;
        private final int k164;
        private final int k264;

        public REM544_PENTANOMIAL_K3_IS_128_GF2X(int k1, int k2, int ki, int ki64, int k164, int k264, long mask) {
            this.k1 = k1;
            this.k2 = k2;
            this.ki = ki;
            this.ki64 = ki64;
            this.k164 = k164;
            this.k264 = k264;
            this.mask = mask;
        }

        @Override
        public void rem_gf2n(long[] P, int p_cp, long[] Pol) {
            long Q2 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long Q3 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long Q1 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            P[p_cp + 4] = Pol[4] ^ Q1 ^ Q2 ^ Q3 >>> this.k164 ^ Q1 << this.k1 ^ Q3 >>> this.k264 ^ Q1 << this.k2;
            long Q5 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            P[p_cp + 5] = Pol[5] ^ Q5 ^ Q3 ^ Q1 >>> this.k164 ^ Q5 << this.k1 ^ Q1 >>> this.k264 ^ Q5 << this.k2;
            long Q0 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            P[p_cp + 6] = Pol[6] ^ Q0 ^ Q1 ^ Q5 >>> this.k164 ^ Q0 << this.k1 ^ Q5 >>> this.k264 ^ Q0 << this.k2;
            Q1 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            P[p_cp + 7] = Pol[7] ^ Q1 ^ Q5 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2;
            Q5 = Pol[16] >>> this.ki;
            P[p_cp + 8] = (Pol[8] ^ Q5 ^ Q0 ^ Q1 >>> this.k164 ^ Q5 << this.k1 ^ Q1 >>> this.k264 ^ Q5 << this.k2) & this.mask;
            Q0 = (Pol[8] ^ Q0) >>> this.ki ^ (Pol[9] ^ Q1) << this.ki64 ^ Pol[16] >>> this.k264;
            Q1 = (Pol[9] ^ Q1) >>> this.ki ^ (Pol[10] ^ Q5) << this.ki64;
            P[p_cp] = Pol[0] ^ Q0 ^ Q0 << this.k1 ^ Q0 << this.k2;
            P[p_cp + 1] = Pol[1] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2;
            P[p_cp + 2] = Pol[2] ^ Q2 ^ Q0 ^ Q1 >>> this.k164 ^ Q2 << this.k1 ^ Q1 >>> this.k264 ^ Q2 << this.k2;
            P[p_cp + 3] = Pol[3] ^ Q3 ^ Q1 ^ Q2 >>> this.k164 ^ Q3 << this.k1 ^ Q2 >>> this.k264 ^ Q3 << this.k2;
        }

        @Override
        public void rem_gf2n_xor(long[] P, int p_cp, long[] Pol) {
            long Q2 = Pol[10] >>> this.ki ^ Pol[11] << this.ki64;
            long Q3 = Pol[11] >>> this.ki ^ Pol[12] << this.ki64;
            long Q1 = Pol[12] >>> this.ki ^ Pol[13] << this.ki64;
            int n = p_cp + 4;
            P[n] = P[n] ^ (Pol[4] ^ Q1 ^ Q2 ^ Q3 >>> this.k164 ^ Q1 << this.k1 ^ Q3 >>> this.k264 ^ Q1 << this.k2);
            long Q5 = Pol[13] >>> this.ki ^ Pol[14] << this.ki64;
            int n2 = p_cp + 5;
            P[n2] = P[n2] ^ (Pol[5] ^ Q5 ^ Q3 ^ Q1 >>> this.k164 ^ Q5 << this.k1 ^ Q1 >>> this.k264 ^ Q5 << this.k2);
            long Q0 = Pol[14] >>> this.ki ^ Pol[15] << this.ki64;
            int n3 = p_cp + 6;
            P[n3] = P[n3] ^ (Pol[6] ^ Q0 ^ Q1 ^ Q5 >>> this.k164 ^ Q0 << this.k1 ^ Q5 >>> this.k264 ^ Q0 << this.k2);
            Q1 = Pol[15] >>> this.ki ^ Pol[16] << this.ki64;
            int n4 = p_cp + 7;
            P[n4] = P[n4] ^ (Pol[7] ^ Q1 ^ Q5 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2);
            Q5 = Pol[16] >>> this.ki;
            int n5 = p_cp + 8;
            P[n5] = P[n5] ^ (Pol[8] ^ Q5 ^ Q0 ^ Q1 >>> this.k164 ^ Q5 << this.k1 ^ Q1 >>> this.k264 ^ Q5 << this.k2) & this.mask;
            Q0 = (Pol[8] ^ Q0) >>> this.ki ^ (Pol[9] ^ Q1) << this.ki64 ^ Pol[16] >>> this.k264;
            Q1 = (Pol[9] ^ Q1) >>> this.ki ^ (Pol[10] ^ Q5) << this.ki64;
            int n6 = p_cp;
            P[n6] = P[n6] ^ (Pol[0] ^ Q0 ^ Q0 << this.k1 ^ Q0 << this.k2);
            int n7 = p_cp + 1;
            P[n7] = P[n7] ^ (Pol[1] ^ Q1 ^ Q0 >>> this.k164 ^ Q1 << this.k1 ^ Q0 >>> this.k264 ^ Q1 << this.k2);
            int n8 = p_cp + 2;
            P[n8] = P[n8] ^ (Pol[2] ^ Q2 ^ Q0 ^ Q1 >>> this.k164 ^ Q2 << this.k1 ^ Q1 >>> this.k264 ^ Q2 << this.k2);
            int n9 = p_cp + 3;
            P[n9] = P[n9] ^ (Pol[3] ^ Q3 ^ Q1 ^ Q2 >>> this.k164 ^ Q3 << this.k1 ^ Q2 >>> this.k264 ^ Q3 << this.k2);
        }
    }
}

