/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.kyber;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;

public class KyberKEMExtractor
implements EncapsulatedSecretExtractor {
    private KyberEngine engine;
    private KyberPrivateKeyParameters key;

    public KyberKEMExtractor(KyberPrivateKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(privParams);
    }

    private void initCipher(AsymmetricKeyParameter recipientKey) {
        KyberPrivateKeyParameters key = (KyberPrivateKeyParameters)recipientKey;
        this.engine = key.getParameters().getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        byte[] sharedSecret = this.engine.kemDecrypt(encapsulation, this.key.getEncoded());
        return sharedSecret;
    }

    @Override
    public int getEncapsulationLength() {
        return this.engine.getCryptoCipherTextBytes();
    }
}

